/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.XmlReader;
import com.badlogic.gdx.utils.XmlWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class Introspector {
    private final Class mClass;
    private final Object mReference;
    private final Object mObject;
    private final FileHandle mFileHandle;
    private final DelayedRemovalArray<Listener> mListeners = new DelayedRemovalArray();

    public Introspector(Object object, Object reference, FileHandle fileHandle) {
        this.mClass = object.getClass();
        this.mObject = object;
        this.mReference = reference;
        this.mFileHandle = fileHandle;
    }

    public static Introspector fromInstance(Object instance, FileHandle fileHandle) {
        Object reference;
        try {
            reference = instance.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("This should never happen");
        }
        return new Introspector(instance, reference, fileHandle);
    }

    public void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public void load() {
        if (!this.mFileHandle.exists()) {
            return;
        }
        XmlReader.Element root = FileUtils.parseXml(this.mFileHandle);
        if (root == null) {
            return;
        }
        block12: for (XmlReader.Element keyElement : root.getChildrenByName("key")) {
            Field field;
            String name = keyElement.getAttribute("name");
            String type = keyElement.getAttribute("type");
            String value = keyElement.getText();
            try {
                field = this.mClass.getField(name);
            }
            catch (NoSuchFieldException e) {
                NLog.e("No field named '%s', skipping", name);
                continue;
            }
            String fieldType = field.getType().toString();
            if (!fieldType.equals(type)) {
                NLog.e("Field '%s' is of type '%s', but XML expected '%s', skipping", name, fieldType, type);
                continue;
            }
            switch (type) {
                case "int": {
                    this.set(name, Integer.valueOf(value));
                    continue block12;
                }
                case "boolean": {
                    this.set(name, Boolean.valueOf(value));
                    continue block12;
                }
                case "float": {
                    this.set(name, Float.valueOf(value));
                    continue block12;
                }
            }
            throw new RuntimeException("Unsupported type '" + type + "' for field '" + name + "'");
        }
    }

    public void save() {
        XmlWriter writer = new XmlWriter(this.mFileHandle.writer(false));
        try {
            XmlWriter root = writer.element("object");
            for (Field field : this.mClass.getDeclaredFields()) {
                Object value;
                if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || (value = field.get(this.mObject)).equals(field.get(this.mReference))) continue;
                root.element("key").attribute("name", field.getName()).attribute("type", field.getType().toString()).text(value.toString()).pop();
            }
            root.pop();
            writer.close();
        }
        catch (IOException | IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public <T> T get(String key) {
        return this.getFrom(this.mObject, key);
    }

    public <T> T getReference(String key) {
        return this.getFrom(this.mReference, key);
    }

    private <T> T getFrom(Object object, String key) {
        try {
            Field field = this.mClass.getField(key);
            return (T)field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeException("get(" + key + ") failed. " + e);
        }
    }

    public <T> void set(String key, T value) {
        try {
            Field field = this.mClass.getField(key);
            field.set(this.mObject, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeException("set(" + key + ") failed. " + e);
        }
        this.notifyModified();
    }

    public int getInt(String key) {
        try {
            Field field = this.mClass.getField(key);
            return field.getInt(this.mObject);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeException("getInt(" + key + ") failed. " + e);
        }
    }

    public void setInt(String key, int value) {
        try {
            Field field = this.mClass.getField(key);
            field.setInt(this.mObject, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeException("setInt(" + key + ") failed. " + e);
        }
        this.notifyModified();
    }

    public float getFloat(String key) {
        try {
            Field field = this.mClass.getField(key);
            return field.getFloat(this.mObject);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeException("getFloat(" + key + ") failed. " + e);
        }
    }

    public void setFloat(String key, float value) {
        try {
            Field field = this.mClass.getField(key);
            field.setFloat(this.mObject, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeException("setFloat(" + key + ") failed. " + e);
        }
        this.notifyModified();
    }

    public boolean hasBeenModified() {
        for (Field field : this.mClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                if (Objects.equals(field.get(this.mObject), field.get(this.mReference))) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void notifyModified() {
        this.mListeners.begin();
        for (Listener listener : this.mListeners) {
            listener.onModified();
        }
        this.mListeners.end();
    }

    public static interface Listener {
        public void onModified();
    }
}

