/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.racer.LapPositionComponent;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.racescreen.Helicopter;
import com.agateau.pixelwheels.utils.OrientedPoint;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;

public class HoleHandlerComponent
implements Racer.Component {
    private static final float MAX_FALL_DURATION = 0.5f;
    private static final float LIFT_DROP_DURATION = 0.5f;
    private static final float MAX_RECOVERING_ROTATION_SPEED = 360.0f;
    private final Assets mAssets;
    private final GameWorld mGameWorld;
    private final Vehicle mVehicle;
    private final LapPositionComponent mLapPositionComponent;
    private final Track mTrack;
    private final Racer mRacer;
    private final Vector2 mVelocity = new Vector2();
    private Helicopter mHelicopter = null;
    private State mState = State.NORMAL;
    private float mTime;

    public HoleHandlerComponent(Assets assets, GameWorld gameWorld, Racer racer, LapPositionComponent lapPositionComponent) {
        this.mAssets = assets;
        this.mGameWorld = gameWorld;
        this.mRacer = racer;
        this.mVehicle = racer.getVehicle();
        this.mTrack = gameWorld.getTrack();
        this.mLapPositionComponent = lapPositionComponent;
    }

    public State getState() {
        return this.mState;
    }

    public Vehicle getVehicle() {
        return this.mVehicle;
    }

    @Override
    public void act(float delta) {
        switch (this.mState) {
            case NORMAL: {
                this.actNormal();
                break;
            }
            case FALLING: {
                this.actFalling(delta);
                break;
            }
            case CLIMBING: {
                this.actClimbing(delta);
                break;
            }
            case LIFTING: {
                this.actLifting(delta);
                break;
            }
            case RECOVERING: {
                this.actRecovering(delta);
                break;
            }
            case DROPPING: {
                this.actDropping(delta);
            }
        }
    }

    private void actNormal() {
        if (this.isInHole()) {
            this.switchToFallingState();
        }
    }

    private void switchToFallingState() {
        this.mHelicopter = Helicopter.create(this.mAssets, this.mRacer.getAudioManager(), this.mGameWorld.getTrack(), this);
        this.mGameWorld.addGameObject(this.mHelicopter);
        this.mState = State.FALLING;
        this.mTime = 0.0f;
    }

    private void actFalling(float delta) {
        this.mTime = Math.min(this.mTime + delta, 0.5f);
        this.mVehicle.setZ(-this.mTime / 0.5f / 10.0f);
        if (!this.isInHole()) {
            this.switchToClimbingState();
            return;
        }
        this.mHelicopter.setDestination(this.mVehicle.getPosition(), this.mVehicle.getAngle());
        if (this.mHelicopter.isAtDestination()) {
            this.mState = State.LIFTING;
            this.mTime = 0.0f;
            this.mVehicle.setStopped(true);
            this.mVehicle.setFlying(true);
            this.mRacer.looseBonus();
            this.mHelicopter.switchToRecoveringState();
        }
    }

    private void switchToClimbingState() {
        this.mState = State.CLIMBING;
        this.mHelicopter.leave();
    }

    private void actClimbing(float delta) {
        this.mTime = Math.max(this.mTime - delta, 0.0f);
        this.mVehicle.setZ(-this.mTime / 0.5f / 10.0f);
        if (this.mTime == 0.0f) {
            this.switchToNormalState();
            return;
        }
        if (this.isInHole()) {
            this.switchToFallingState();
        }
    }

    private void actLifting(float delta) {
        this.mTime += delta;
        if (this.mTime >= 0.5f) {
            this.mTime = 0.5f;
            this.switchToRecoveringState();
        }
        this.mVehicle.setZ(Interpolation.pow2.apply(this.mTime / 0.5f));
    }

    private void switchToRecoveringState() {
        this.mState = State.RECOVERING;
        float distance = this.mLapPositionComponent.getLapDistance();
        OrientedPoint dropPoint = this.mTrack.getValidPosition(this.mVehicle.getBody().getWorldCenter(), distance);
        this.mHelicopter.setDestination(dropPoint);
    }

    private void actRecovering(float delta) {
        this.mVelocity.set(this.mHelicopter.getPosition()).sub(this.mVehicle.getBody().getPosition()).scl(1.0f / delta);
        float angleDelta = AgcMathUtils.shortestAngleDelta(this.mVehicle.getAngle(), this.mHelicopter.getAngle());
        float angularVelocity = MathUtils.clamp(angleDelta / delta, -360.0f, 360.0f) * ((float)Math.PI / 180);
        this.mVehicle.getBody().setLinearVelocity(this.mVelocity);
        this.mVehicle.getBody().setAngularVelocity(angularVelocity);
        if (this.mHelicopter.isAtDestination()) {
            this.mVehicle.setFlying(false);
            this.mState = State.DROPPING;
            this.mTime = 0.0f;
            this.mHelicopter.leave();
        }
    }

    private void actDropping(float delta) {
        this.mTime += delta;
        this.mVehicle.setZ(Interpolation.bounceOut.apply(1.0f, 0.0f, this.mTime / 0.5f));
        if (this.mTime >= 0.5f) {
            this.mTime = 0.5f;
            this.switchToNormalState();
        }
    }

    private void switchToNormalState() {
        this.mVehicle.setZ(0.0f);
        this.mVehicle.setStopped(false);
        this.mState = State.NORMAL;
    }

    public boolean isInHole() {
        return this.mGameWorld.getTrack().getMaterialAt(this.mVehicle.getPosition()).isHole();
    }

    public static enum State {
        NORMAL,
        FALLING,
        CLIMBING,
        LIFTING,
        RECOVERING,
        DROPPING;

    }
}

