/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.Scene2dUtils;
import com.agateau.ui.menu.FocusIndicator;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItem;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class SwitchMenuItem
extends Actor
implements MenuItem {
    private static final float SWITCH_SPEED = 10.0f;
    private final Rectangle mFocusRectangle = new Rectangle();
    private final FocusIndicator mFocusIndicator;
    private final BitmapFont mFont;
    private final SwitchMenuItemStyle mStyle;
    private boolean mChecked = false;
    private float mXOffset = 0.0f;

    public SwitchMenuItem(Menu menu) {
        this.mFocusIndicator = new FocusIndicator(menu);
        this.setTouchable(Touchable.enabled);
        this.mFont = menu.getSkin().get("symbols-font", BitmapFont.class);
        this.mStyle = menu.getSkin().get(SwitchMenuItemStyle.class);
        this.setSize(this.mStyle.frame.getMinWidth() * 2.0f, this.mStyle.frame.getMinHeight());
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SwitchMenuItem.this.trigger();
            }
        });
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        this.mXOffset = this.mChecked ? 1.0f : 0.0f;
    }

    @Override
    public Actor getActor() {
        return this;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setFocused(boolean focused) {
        this.mFocusIndicator.setFocused(focused);
    }

    @Override
    public void trigger() {
        this.mChecked = !this.mChecked;
        Scene2dUtils.fireChangeEvent(this);
    }

    @Override
    public boolean goUp() {
        return false;
    }

    @Override
    public boolean goDown() {
        return false;
    }

    @Override
    public void goLeft() {
        if (this.mChecked) {
            this.trigger();
        }
    }

    @Override
    public void goRight() {
        if (!this.mChecked) {
            this.trigger();
        }
    }

    @Override
    public Rectangle getFocusRectangle() {
        this.mFocusRectangle.x = 0.0f;
        this.mFocusRectangle.y = 0.0f;
        this.mFocusRectangle.width = this.getWidth();
        this.mFocusRectangle.height = this.getHeight();
        return this.mFocusRectangle;
    }

    @Override
    public float getParentWidthRatio() {
        return 0.0f;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.mFocusIndicator.act(delta);
        if (this.mChecked && this.mXOffset < 1.0f) {
            this.mXOffset = Math.min(1.0f, this.mXOffset + delta * 10.0f);
        } else if (!this.mChecked && this.mXOffset > 0.0f) {
            this.mXOffset = Math.max(0.0f, this.mXOffset - delta * 10.0f);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.mFocusIndicator.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.mStyle.frame.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        Drawable handle = this.mStyle.handle;
        float padding = this.mStyle.framePadding;
        float handleWidth = (this.getWidth() - 2.0f * padding) / 2.0f;
        float x = handleWidth * this.mXOffset;
        handle.draw(batch, this.getX() + x + padding, this.getY() + padding, handleWidth, this.getHeight() - 2.0f * padding);
        float y = this.getY() + (this.mFont.getCapHeight() + this.getHeight()) / 2.0f;
        this.mFont.draw(batch, this.formatValue(false), this.getX() + padding, y, handleWidth, 1, false);
        this.mFont.draw(batch, this.formatValue(true), this.getX() + padding + handleWidth, y, handleWidth, 1, false);
    }

    protected String formatValue(boolean value) {
        return value ? "\u23fd" : "\u2b58";
    }

    public static class SwitchMenuItemStyle {
        public Drawable frame;
        public float framePadding;
        public Drawable handle;
    }
}

