/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.uibuilder;

import com.agateau.translations.Translator;
import com.agateau.ui.AgcTiledImage;
import com.agateau.ui.AnimatedImage;
import com.agateau.ui.DimensionParser;
import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.anchor.PositionRule;
import com.agateau.ui.animscript.AnimScript;
import com.agateau.ui.animscript.AnimScriptLoader;
import com.agateau.ui.menu.ButtonMenuItem;
import com.agateau.ui.menu.ImageMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItem;
import com.agateau.ui.menu.MenuScrollPane;
import com.agateau.ui.menu.SpacerMenuItem;
import com.agateau.ui.uibuilder.ElementTreeTraversor;
import com.agateau.utils.Assert;
import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.XmlReader;
import java.util.HashMap;
import java.util.Map;

public class UiBuilder {
    private static final String PREVIOUS_ACTOR_ID = "$prev";
    private final AnimScriptLoader mAnimScriptLoader = new AnimScriptLoader();
    private final DimensionParser mDimParser = new DimensionParser();
    private final ElementTreeTraversor mTraversor = new ElementTreeTraversor();
    private final Map<String, Actor> mActorForId = new HashMap<String, Actor>();
    private final Map<String, MenuItem> mMenuItemForId = new HashMap<String, MenuItem>();
    private final Map<String, ActorFactory> mActorFactories = new HashMap<String, ActorFactory>();
    private final Map<String, MenuItemFactory> mMenuItemFactories = new HashMap<String, MenuItemFactory>();
    private final TextureAtlas mAtlas;
    private final Skin mSkin;
    private Actor mLastAddedActor;
    private final Map<String, TextureAtlas> mAtlasMap = new HashMap<String, TextureAtlas>();
    private final Map<String, String> mConfigMap = new HashMap<String, String>();
    private final Array<ActorIdActionPair> mPendingActions = new Array();
    private static final String[] ANCHOR_NAMES = new String[]{"topLeft", "topCenter", "topRight", "centerLeft", "center", "centerRight", "bottomLeft", "bottomCenter", "bottomRight"};
    private static final Anchor[] ANCHORS = new Anchor[]{Anchor.TOP_LEFT, Anchor.TOP_CENTER, Anchor.TOP_RIGHT, Anchor.CENTER_LEFT, Anchor.CENTER, Anchor.CENTER_RIGHT, Anchor.BOTTOM_LEFT, Anchor.BOTTOM_CENTER, Anchor.BOTTOM_RIGHT};

    public UiBuilder(TextureAtlas atlas, Skin skin) {
        this.mAtlas = atlas;
        this.mSkin = skin;
        this.initActorFactories();
        this.initMenuItemFactories();
    }

    private void initActorFactories() {
        this.mActorFactories.put("Image", (uiBuilder, element) -> {
            TextureAtlas atlas = this.getAtlasForElement(element);
            String name = element.getAttribute("name", "");
            boolean tiled = element.getBooleanAttribute("tiled", false);
            if (tiled) {
                AgcTiledImage image = new AgcTiledImage();
                TextureAtlas.AtlasRegion region = atlas.findRegion(name);
                image.setRegion(region);
                return image;
            }
            Image image = new Image();
            if (!name.isEmpty()) {
                if (name.endsWith(".9")) {
                    this.initImageFromNinePatchName(image, atlas, name);
                } else {
                    this.initImageFromRegionName(image, atlas, name);
                }
                image.pack();
            }
            return image;
        });
        this.mActorFactories.put("AnimatedImage", (uiBuilder, element) -> {
            String name = element.getAttribute("name", null);
            if (name == null) {
                throw new SyntaxException("Missing 'name' attribute");
            }
            float frameDuration = element.getFloatAttribute("frameDuration", 0.1f);
            float startTime = element.getFloatAttribute("startTime", 0.0f);
            TextureAtlas atlas = this.getAtlasForElement(element);
            Animation<TextureRegion> anim = new Animation<TextureRegion>(frameDuration, atlas.findRegions(name));
            AnimatedImage image = new AnimatedImage(anim);
            image.setStartTime(startTime);
            return image;
        });
        this.mActorFactories.put("ImageButton", (uiBuilder, element) -> {
            String styleName = element.getAttribute("style", "default");
            ImageButton.ImageButtonStyle style = new ImageButton.ImageButtonStyle(this.mSkin.get(styleName, ImageButton.ImageButtonStyle.class));
            String imageName = element.getAttribute("imageName", "");
            if (!imageName.isEmpty()) {
                style.imageUp = this.mSkin.getDrawable(imageName);
            }
            ImageButton button = new ImageButton(style);
            String imageColor = element.getAttribute("imageColor", "");
            if (!imageColor.isEmpty()) {
                Color color = Color.valueOf(imageColor);
                button.getImage().setColor(color);
            }
            return button;
        });
        this.mActorFactories.put("TextButton", (uiBuilder, element) -> {
            String styleName = element.getAttribute("style", "default");
            String text = Translator.tr(UiBuilder.processText(element.getText()));
            return new TextButton(text, this.mSkin, styleName);
        });
        this.mActorFactories.put("Group", (uiBuilder, element) -> new Group());
        this.mActorFactories.put("AnchorGroup", (uiBuilder, element) -> {
            this.mDimParser.gridSize = this.mDimParser.parse(element.getAttribute("gridSize", "1"));
            AnchorGroup group = new AnchorGroup();
            group.setGridSize(this.mDimParser.gridSize);
            return group;
        });
        this.mActorFactories.put("Label", (uiBuilder, element) -> {
            String styleName = element.getAttribute("style", "default");
            String text = Translator.tr(UiBuilder.processText(element.getText()));
            Label label = new Label(text, this.mSkin, styleName);
            int align = UiBuilder.parseAlign(element);
            if (align != -1) {
                label.setAlignment(align);
            }
            if (element.getBooleanAttribute("wrap", false)) {
                label.setWrap(true);
            }
            return label;
        });
        this.mActorFactories.put("ScrollPane", (uiBuilder, element) -> {
            String styleName = element.getAttribute("style", "");
            ScrollPane pane = styleName.isEmpty() ? new ScrollPane(null) : new ScrollPane(null, this.mSkin, styleName);
            Actor child = this.buildChildren(element, null);
            if (child != null) {
                pane.setActor(child);
            }
            return pane;
        });
        this.mActorFactories.put("VerticalGroup", (uiBuilder, element) -> {
            VerticalGroup group = new VerticalGroup();
            float spacing = this.mDimParser.parse(element.getAttribute("spacing", "0"));
            group.space(spacing);
            int align = UiBuilder.parseAlign(element);
            if (align != -1) {
                group.align(align);
            }
            return group;
        });
        this.mActorFactories.put("HorizontalGroup", (uiBuilder, element) -> {
            HorizontalGroup group = new HorizontalGroup();
            float spacing = this.mDimParser.parse(element.getAttribute("spacing", "0"));
            group.space(spacing);
            return group;
        });
        this.mActorFactories.put("CheckBox", (uiBuilder, element) -> {
            String styleName = element.getAttribute("style", "default");
            String text = Translator.tr(element.getText());
            return new CheckBox(text, this.mSkin, styleName);
        });
        this.mActorFactories.put("Menu", (uiBuilder, element) -> this.createMenu(element));
        this.mActorFactories.put("MenuScrollPane", (uiBuilder, element) -> {
            Menu menu = this.createMenu(element);
            return new MenuScrollPane(menu);
        });
        this.mActorFactories.put("Table", (uiBuilder, element) -> new Table(this.mSkin));
    }

    private void initMenuItemFactories() {
        this.mMenuItemFactories.put("ButtonMenuItem", (menu, element) -> {
            String label = element.getAttribute("label", null);
            String text = Translator.tr(element.getAttribute("text", ""));
            float ratio = element.getFloatAttribute("parentWidthAspectRatio", 1.0f);
            ButtonMenuItem item = new ButtonMenuItem(menu, text);
            if (label == null) {
                menu.addItem(item);
            } else {
                menu.addItemWithLabel(Translator.tr(label), item);
            }
            item.setParentWidthRatio(ratio);
            return item;
        });
        this.mMenuItemFactories.put("LabelMenuItem", (menu, element) -> {
            String text = Translator.tr(element.getAttribute("text"));
            return menu.addLabel(text);
        });
        this.mMenuItemFactories.put("ImageMenuItem", (menu, element) -> {
            String name = element.getAttribute("name");
            Drawable drawable = this.mSkin.getDrawable(name);
            ImageMenuItem item = new ImageMenuItem(drawable);
            return menu.addItem(item);
        });
        this.mMenuItemFactories.put("SpacerMenuItem", (menu, element) -> {
            String heightStr = element.getAttribute("height", null);
            float height = heightStr == null ? (float)menu.getMenuStyle().spacing : this.mDimParser.parse(heightStr);
            SpacerMenuItem item = new SpacerMenuItem(height);
            return menu.addItem(item);
        });
    }

    public void defineVariable(String name) {
        this.mTraversor.defineVariable(name);
    }

    public Actor build(FileHandle handle) {
        return this.build(handle, null);
    }

    public Actor build(XmlReader.Element parentElement) {
        return this.build(parentElement, null);
    }

    public Actor build(FileHandle handle, Group parentActor) {
        XmlReader.Element element = FileUtils.parseXml(handle);
        assert (element != null);
        return this.build(element, parentActor);
    }

    public Actor build(XmlReader.Element parentElement, Group parentActor) {
        this.mActorForId.clear();
        this.mMenuItemForId.clear();
        try {
            Actor root = this.buildChildren(parentElement, parentActor);
            this.assignPendingActions();
            return root;
        }
        catch (SyntaxException e) {
            NLog.e("Parse error: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public TextureAtlas getAtlas() {
        return this.mAtlas;
    }

    public Skin getSkin() {
        return this.mSkin;
    }

    public void addAtlas(String name, TextureAtlas atlas) {
        this.mAtlasMap.put(name, atlas);
    }

    public Actor buildChildren(XmlReader.Element parentElement, Group parentActor) throws SyntaxException {
        Actor[] root = new Actor[]{null};
        this.mTraversor.traverseElementTree(parentElement, element -> {
            if (element.getName().equals("Config")) {
                this.readConfig(element);
                return;
            }
            Actor actor = this.createActorForElement(element);
            if (actor == null) {
                throw new SyntaxException("Failed to create actor for element: " + element);
            }
            if (actor instanceof Widget) {
                this.applyWidgetProperties((Widget)actor, element);
            }
            this.applyActorProperties(actor, element, parentActor);
            this.createActorActions(actor, element);
            String id = element.getAttribute("id", null);
            if (id != null) {
                actor.setName(id);
            }
            this.addActorToActorForId(id, actor);
            if (actor instanceof Group && !(actor instanceof ScrollPane) && !(actor instanceof Menu)) {
                this.buildChildren(element, (Group)actor);
            }
            this.mLastAddedActor = actor;
            if (root[0] == null) {
                root[0] = actor;
            }
        });
        return root[0];
    }

    private void readConfig(XmlReader.Element parent) throws SyntaxException {
        for (XmlReader.Element element : parent.getChildrenByName("ConfigItem")) {
            String id = element.getAttribute("id", "");
            if (id.equals("")) {
                throw new SyntaxException("Missing or empty 'id' attribute in ConfigItem");
            }
            String value = element.getText();
            this.mConfigMap.put(id, value);
        }
    }

    private void addActorToActorForId(String id, Actor actor) throws SyntaxException {
        if (id != null) {
            if (this.mActorForId.containsKey(id)) {
                throw new SyntaxException("Duplicate ids: " + id);
            }
            this.mActorForId.put(id, actor);
        }
    }

    public float getFloatConfigValue(String id) {
        String value = this.mConfigMap.get(id);
        if (value == null) {
            NLog.e("Unknown config id '%s'", id);
            return 0.0f;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            NLog.e("Invalid float value for id '%s': '%s'", id, value);
            return 0.0f;
        }
    }

    public int getIntConfigValue(String id) {
        String value = this.mConfigMap.get(id);
        if (value == null) {
            NLog.e("Unknown config id '%s'", id);
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            NLog.e("Invalid int value for id '%s': '%s'", id, value);
            return 0;
        }
    }

    public String getStringConfigValue(String id) {
        String value = this.mConfigMap.get(id);
        if (value == null) {
            NLog.e("Unknown config id '%s'", id);
            return "";
        }
        return value;
    }

    public AnimScript getAnimScriptConfigValue(String id) throws AnimScriptLoader.SyntaxException {
        String definition = this.mConfigMap.get(id);
        return this.mAnimScriptLoader.load(definition, this.mDimParser);
    }

    public <T extends Actor> T getActor(String id) {
        Actor actor = id.equals(PREVIOUS_ACTOR_ID) ? this.mLastAddedActor : this.mActorForId.get(id);
        if (actor == null) {
            throw new RuntimeException("No actor with id '" + id + "'");
        }
        Actor obj = actor;
        return (T)obj;
    }

    public <T extends MenuItem> T getMenuItem(String id) {
        MenuItem item = this.mMenuItemForId.get(id);
        if (item == null) {
            throw new RuntimeException("No menu item with id '" + id + "'");
        }
        MenuItem obj = item;
        return (T)obj;
    }

    private Actor createActorForElement(XmlReader.Element element) throws SyntaxException {
        String name = element.getName();
        ActorFactory factory = this.mActorFactories.get(name);
        if (factory != null) {
            return factory.createActor(this, element);
        }
        throw new SyntaxException("Unknown UI element type: " + name);
    }

    private TextureAtlas getAtlasForElement(XmlReader.Element element) {
        String name = element.getAttribute("atlas", "");
        if (name.isEmpty()) {
            return this.mAtlas;
        }
        return this.mAtlasMap.get(name);
    }

    private void initImageFromNinePatchName(Image image, TextureAtlas atlas, String name) {
        NinePatch patch = atlas.createPatch(name.substring(0, name.length() - 2));
        image.setDrawable(new NinePatchDrawable(patch));
    }

    private void initImageFromRegionName(Image image, TextureAtlas atlas, String name) {
        TextureAtlas.AtlasRegion region = atlas.findRegion(name);
        Assert.check(region != null, "No region named " + name, new Object[0]);
        image.setDrawable(new TextureRegionDrawable(region));
        if (image.getWidth() == 0.0f) {
            image.setWidth(region.getRegionWidth());
        }
        if (image.getHeight() == 0.0f) {
            image.setHeight(region.getRegionHeight());
        }
    }

    private Menu createMenu(XmlReader.Element element) throws SyntaxException {
        XmlReader.Element items;
        String styleName = element.getAttribute("style", "default");
        Menu menu = new Menu(this.mSkin, styleName);
        String attr = element.getAttribute("labelColumnWidth", "");
        if (!attr.isEmpty()) {
            float width = this.mDimParser.parse(attr, DimensionParser.Unit.PIXEL);
            menu.setLabelColumnWidth(width);
        }
        if ((items = element.getChildByName("Items")) != null) {
            this.mTraversor.traverseElementTree(items, itemElement -> {
                String name = itemElement.getName();
                MenuItemFactory factory = this.mMenuItemFactories.get(name);
                if (factory == null) {
                    throw new SyntaxException("Invalid menu item type: " + name);
                }
                String id = itemElement.getAttribute("id", null);
                MenuItem menuItem = factory.createMenuItem(menu, itemElement);
                Actor actor = menuItem.getActor();
                if (id != null) {
                    this.mMenuItemForId.put(id, menuItem);
                    this.addActorToActorForId(id, actor);
                }
            });
        }
        return menu;
    }

    private void applyWidgetProperties(Widget widget, XmlReader.Element element) {
        widget.setFillParent(element.getBooleanAttribute("fillParent", false));
    }

    private void applyActorProperties(Actor actor, XmlReader.Element element, Group parentActor) throws SyntaxException {
        String attr;
        AnchorGroup anchorGroup = null;
        if (parentActor != null) {
            parentActor.addActor(actor);
            if (parentActor instanceof AnchorGroup) {
                anchorGroup = (AnchorGroup)parentActor;
            }
        }
        if (!(attr = element.getAttribute("x", "")).isEmpty()) {
            actor.setX(this.mDimParser.parse(attr));
        }
        if (!(attr = element.getAttribute("y", "")).isEmpty()) {
            actor.setY(this.mDimParser.parse(attr));
        }
        boolean explicitWidth = false;
        attr = element.getAttribute("width", "");
        if (!attr.isEmpty()) {
            explicitWidth = true;
            actor.setWidth(this.mDimParser.parse(attr));
        }
        if ((attr = element.getAttribute("height", "")).isEmpty()) {
            if (actor instanceof Label) {
                Label label = (Label)actor;
                if (explicitWidth && label.getWrap()) {
                    label.setHeight(label.getPrefHeight());
                }
            }
        } else {
            actor.setHeight(this.mDimParser.parse(attr));
        }
        if (!(attr = element.getAttribute("originX", "")).isEmpty()) {
            actor.setOriginX(this.mDimParser.parse(attr));
        }
        if (!(attr = element.getAttribute("originY", "")).isEmpty()) {
            actor.setOriginY(this.mDimParser.parse(attr));
        }
        if (!(attr = element.getAttribute("visible", "")).isEmpty()) {
            actor.setVisible(Boolean.parseBoolean(attr));
        }
        if (!(attr = element.getAttribute("color", "")).isEmpty()) {
            actor.setColor(Color.valueOf(attr));
        }
        if (!(attr = element.getAttribute("debug", "")).isEmpty()) {
            if (actor instanceof Group) {
                Group group = (Group)actor;
                if ((attr = attr.toLowerCase()).equals("true")) {
                    group.debug();
                } else if (attr.equals("all")) {
                    group.debugAll();
                }
            } else {
                actor.setDebug(Boolean.parseBoolean(attr));
            }
        }
        int size = ANCHOR_NAMES.length;
        for (int idx = 0; idx < size; ++idx) {
            String anchorName = ANCHOR_NAMES[idx];
            attr = element.getAttribute(anchorName, "");
            if (attr.isEmpty()) continue;
            if (anchorGroup == null) {
                throw new SyntaxException("Parent of " + actor + " is not an anchor group");
            }
            PositionRule rule = this.parseRule(attr);
            rule.target = actor;
            rule.targetAnchor = ANCHORS[idx];
            anchorGroup.addRule(rule);
        }
    }

    private PositionRule parseRule(String txt) throws SyntaxException {
        PositionRule rule = new PositionRule();
        String[] tokens = txt.split(" +");
        if (tokens.length != 1 && tokens.length != 3) {
            throw new SyntaxException("Invalid rule syntax: " + txt);
        }
        String[] tokens2 = tokens[0].split("\\.");
        if (tokens2.length != 2) {
            throw new SyntaxException("reference should be of the form <id>.<anchor>: " + txt);
        }
        rule.reference = this.getActor(tokens2[0]);
        int size = ANCHOR_NAMES.length;
        for (int idx = 0; idx < size; ++idx) {
            if (!tokens2[1].equals(ANCHOR_NAMES[idx])) continue;
            rule.referenceAnchor = ANCHORS[idx];
            break;
        }
        if (rule.referenceAnchor == null) {
            throw new SyntaxException("Invalid anchor name: '" + tokens[1] + "'");
        }
        if (tokens.length == 3) {
            rule.hSpace = this.mDimParser.parse(tokens[1], DimensionParser.Unit.GRID);
            rule.vSpace = this.mDimParser.parse(tokens[2], DimensionParser.Unit.GRID);
        }
        return rule;
    }

    public void registerActorFactory(String name, ActorFactory factory) {
        this.mActorFactories.put(name, factory);
    }

    public void registerMenuItemFactory(String name, MenuItemFactory factory) {
        this.mMenuItemFactories.put(name, factory);
    }

    private static String processText(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("\\n", "\n");
    }

    private void createActorActions(Actor actor, XmlReader.Element element) {
        for (XmlReader.Element child : element.getChildrenByName("Action")) {
            AnimScript script;
            String definition = child.getText();
            try {
                script = this.mAnimScriptLoader.load(definition, this.mDimParser);
            }
            catch (AnimScriptLoader.SyntaxException e) {
                NLog.e("Failed to parse:\n" + definition + "\n\n%s", e);
                continue;
            }
            Action action = script.createAction();
            String actorId = child.getAttribute("actor", "");
            if (actorId.equals("")) {
                actor.addAction(action);
                continue;
            }
            this.mPendingActions.add(new ActorIdActionPair(actorId, action));
        }
    }

    private void assignPendingActions() {
        for (ActorIdActionPair pair : this.mPendingActions) {
            Actor target = this.mActorForId.get(pair.actorId);
            if (target == null) {
                NLog.e("Failed to assign action to actor %s: actor not found", pair.actorId);
                continue;
            }
            target.addAction(pair.action);
        }
        this.mPendingActions.clear();
    }

    private static int parseAlign(XmlReader.Element element) throws SyntaxException {
        String alignText = element.getAttribute("align", "");
        if (alignText.isEmpty()) {
            return -1;
        }
        switch (alignText) {
            case "center": {
                return 1;
            }
            case "centerLeft": {
                return 8;
            }
            case "centerRight": {
                return 16;
            }
            case "topLeft": {
                return 10;
            }
            case "topCenter": {
                return 2;
            }
            case "topRight": {
                return 18;
            }
            case "bottomLeft": {
                return 12;
            }
            case "bottomCenter": {
                return 4;
            }
            case "bottomRight": {
                return 20;
            }
        }
        throw new SyntaxException("Unknown value of 'align': " + alignText);
    }

    public static interface ActorFactory {
        public Actor createActor(UiBuilder var1, XmlReader.Element var2) throws SyntaxException;
    }

    public static interface MenuItemFactory {
        public MenuItem createMenuItem(Menu var1, XmlReader.Element var2) throws SyntaxException;
    }

    public static class SyntaxException
    extends Exception {
        public SyntaxException(String message) {
            super(message);
        }
    }

    private static class ActorIdActionPair {
        final String actorId;
        final Action action;

        public ActorIdActionPair(String actorId, Action action) {
            this.actorId = actorId;
            this.action = action;
        }
    }
}

