/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

import com.agateau.utils.FileUtils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class ScreenshotCreator {
    private static final String FILENAME_FORMAT = "screenshot-%tF-%<tH%<tM%<tS.%<tL.png";
    private static Pixmap sPixmap;
    private static PixmapIO.PNG sPNG;

    public static String saveScreenshot() {
        Pixmap pixmap = ScreenshotCreator.takeScreenshot();
        FileHandle handle = ScreenshotCreator.generateFileHandle();
        try {
            sPNG.write(handle, pixmap);
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error writing PNG: " + handle, ex);
        }
        return handle.path();
    }

    public static Pixmap takeScreenshot() {
        int width = Gdx.graphics.getWidth();
        int height = Gdx.graphics.getHeight();
        if (sPixmap == null) {
            ScreenshotCreator.init();
        }
        Gdx.gl.glReadPixels(0, 0, width, height, 6407, 5121, sPixmap.getPixels());
        return sPixmap;
    }

    private static void init() {
        int width = Gdx.graphics.getWidth();
        int height = Gdx.graphics.getHeight();
        sPixmap = new Pixmap(width, height, Pixmap.Format.RGB888);
        sPNG = new PixmapIO.PNG((int)((float)(width * height) * 1.5f));
    }

    private static FileHandle generateFileHandle() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        String path = "screenshots" + File.separator + String.format(Locale.US, FILENAME_FORMAT, calendar);
        return FileUtils.getUserWritableFile(path);
    }
}

