/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.debug.DebugShapeMap;
import com.agateau.pixelwheels.gameobject.CellFrameBufferManager;
import com.agateau.pixelwheels.gameobject.CellFrameBufferUser;
import com.agateau.pixelwheels.gameobject.GameObject;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.map.WaypointStore;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racescreen.CameraUpdater;
import com.agateau.pixelwheels.racescreen.FreeCameraUpdater;
import com.agateau.pixelwheels.racescreen.HeadingUpCameraUpdater;
import com.agateau.pixelwheels.racescreen.PwTiledMapRenderer;
import com.agateau.pixelwheels.racescreen.RacerCameraUpdater;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.utils.PerformanceCounter;
import com.badlogic.gdx.utils.PerformanceCounters;

public class GameRenderer {
    private final Track mTrack;
    private final PwTiledMapRenderer mRenderer;
    private final Box2DDebugRenderer mDebugRenderer;
    private final Batch mBatch;
    private final OrthographicCamera mCamera;
    private final ShapeRenderer mShapeRenderer = new ShapeRenderer();
    private final GameWorld mWorld;
    private final CameraUpdater mCameraUpdater;
    private final int[] mBackgroundLayerFirstIndexes = new int[]{0};
    private final int[] mExtraBackgroundLayerIndexes;
    private final int[] mForegroundLayerIndexes;
    private int mScreenX;
    private int mScreenY;
    private int mScreenWidth;
    private int mScreenHeight;
    private final CellFrameBufferManager mCellFrameBufferManager = new CellFrameBufferManager();
    private final PerformanceCounter mTilePerformanceCounter;
    private final PerformanceCounter mGameObjectPerformanceCounter;
    private final PerformanceCounter mSetupPerformanceCounter;
    private final Vector3 sTmp3 = new Vector3();

    public GameRenderer(GameWorld world, Racer racer, Batch batch, boolean headingUp, PerformanceCounters counters) {
        this.mDebugRenderer = new Box2DDebugRenderer();
        this.mWorld = world;
        this.mTrack = this.mWorld.getTrack();
        this.mExtraBackgroundLayerIndexes = this.mTrack.getExtraBackgroundLayerIndexes();
        this.mForegroundLayerIndexes = this.mTrack.getForegroundLayerIndexes();
        this.mBatch = batch;
        this.mCamera = new OrthographicCamera();
        this.mCameraUpdater = GamePlay.instance.freeCamera ? new FreeCameraUpdater(this.mWorld) : (headingUp ? new HeadingUpCameraUpdater(this.mWorld, racer) : new RacerCameraUpdater(this.mWorld, racer));
        this.mRenderer = new PwTiledMapRenderer(this.mTrack.getMap(), 0.05f, this.mBatch);
        this.mSetupPerformanceCounter = counters.add("- setup");
        this.mTilePerformanceCounter = counters.add("- tiles");
        this.mGameObjectPerformanceCounter = counters.add("- g.o.");
        this.mDebugRenderer.setDrawVelocities(Debug.instance.drawVelocities);
        if (Debug.instance.showDebugLayer) {
            this.setupWaypointDebugShape();
        }
        for (GameObject object : this.mWorld.getActiveGameObjects()) {
            if (!(object instanceof CellFrameBufferUser)) continue;
            CellFrameBufferUser user = (CellFrameBufferUser)((Object)object);
            user.init(this.mCellFrameBufferManager);
        }
    }

    private void setupWaypointDebugShape() {
        DebugShapeMap.put("waypoints", renderer -> {
            WaypointStore store = this.mTrack.getWaypointStore();
            renderer.begin(ShapeRenderer.ShapeType.Line);
            for (int idx = 0; idx < store.getCount(); ++idx) {
                renderer.setColor(idx % 2, 1.0f, 0.0f, 1.0f);
                int prevIdx = store.getPreviousIndex(idx);
                renderer.line(store.getWaypoint(prevIdx), store.getWaypoint(idx));
            }
            renderer.end();
        });
    }

    public void setScreenRect(int x, int y, int width, int height) {
        this.mScreenX = x;
        this.mScreenY = y;
        this.mScreenWidth = width;
        this.mScreenHeight = height;
        this.mCameraUpdater.init(this.mCamera, width, height);
    }

    public void onAboutToStart() {
        this.updateCamera(-1.0f);
    }

    public void render(float delta) {
        this.mSetupPerformanceCounter.start();
        HdpiUtils.glViewport(this.mScreenX, this.mScreenY, this.mScreenWidth, this.mScreenHeight);
        this.updateCamera(delta);
        this.updateMapRendererCamera();
        Rectangle viewBounds = this.mRenderer.getViewBounds();
        this.mSetupPerformanceCounter.stop();
        this.mTilePerformanceCounter.start();
        this.mBatch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.mBatch.disableBlending();
        this.mRenderer.render(this.mBackgroundLayerFirstIndexes);
        this.mBatch.enableBlending();
        if (this.mExtraBackgroundLayerIndexes.length > 0) {
            this.mRenderer.render(this.mExtraBackgroundLayerIndexes);
        }
        this.mTilePerformanceCounter.stop();
        this.mGameObjectPerformanceCounter.start();
        this.mCellFrameBufferManager.begin(this.mBatch);
        for (GameObject gameObject : this.mWorld.getActiveGameObjects()) {
            if (!(gameObject instanceof CellFrameBufferUser)) continue;
            CellFrameBufferUser user = (CellFrameBufferUser)((Object)gameObject);
            user.drawToCell(this.mBatch, viewBounds);
        }
        this.mCellFrameBufferManager.end(this.mScreenX, this.mScreenY, this.mScreenWidth, this.mScreenHeight);
        this.mBatch.begin();
        for (ZLevel z : ZLevel.values()) {
            if (z == ZLevel.FG_LAYERS && this.mForegroundLayerIndexes.length > 0) {
                this.mGameObjectPerformanceCounter.stop();
                this.mTilePerformanceCounter.start();
                this.mBatch.end();
                this.mRenderer.render(this.mForegroundLayerIndexes);
                this.mBatch.begin();
                this.mTilePerformanceCounter.stop();
                this.mGameObjectPerformanceCounter.start();
            }
            for (GameObject object : this.mWorld.getActiveGameObjects()) {
                object.draw(this.mBatch, z, viewBounds);
            }
        }
        this.mBatch.end();
        this.mGameObjectPerformanceCounter.stop();
        if (Debug.instance.showDebugLayer) {
            this.mShapeRenderer.setProjectionMatrix(this.mCamera.combined);
            if (Debug.instance.drawTileCorners) {
                this.mShapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
                this.mShapeRenderer.setColor(1.0f, 0.0f, 0.0f, 1.0f);
                float tileW = this.mTrack.getTileWidth();
                float f = this.mTrack.getTileHeight();
                float mapWidth = this.mTrack.getMapWidth();
                float mapHeight = this.mTrack.getMapHeight();
                for (float y = 0.0f; y < mapHeight; y += f) {
                    for (float x = 0.0f; x < mapWidth; x += tileW) {
                        this.mShapeRenderer.rect(x, y, 0.05f, 0.05f);
                    }
                }
                this.mShapeRenderer.end();
            }
            for (DebugShapeMap.Shape shape : DebugShapeMap.values()) {
                shape.draw(this.mShapeRenderer);
            }
            this.mDebugRenderer.render(this.mWorld.getBox2DWorld(), this.mCamera.combined);
        }
    }

    private void updateCamera(float delta) {
        this.mCameraUpdater.update(delta);
    }

    private void updateMapRendererCamera() {
        this.mRenderer.setView(this.mCamera);
    }

    public void mapFromScreen(Vector2 coord) {
        this.sTmp3.set(coord, 0.0f);
        this.sTmp3.x -= (float)this.mScreenX;
        this.sTmp3.y -= (float)this.mScreenY;
        this.sTmp3.x *= (float)Gdx.graphics.getWidth() / (float)this.mScreenWidth;
        this.sTmp3.y *= (float)Gdx.graphics.getHeight() / (float)this.mScreenHeight;
        this.mCamera.unproject(this.sTmp3);
        coord.set(this.sTmp3.x, this.sTmp3.y);
    }
}

