/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.VehicleSelector;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.pixelwheels.utils.UiUtils;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.translations.Translator;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.GridMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class SelectVehicleScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final Listener mListener;
    private VehicleSelector mVehicleSelector;
    private Label mVehicleNameLabel;
    private Label mUnlockHintLabel;
    private Button mNextButton;

    public SelectVehicleScreen(PwGame game, Listener listener) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mListener = listener;
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                SelectVehicleScreen.this.mGame.replaceScreen(new SelectVehicleScreen(SelectVehicleScreen.this.mGame, SelectVehicleScreen.this.mListener));
            }
        };
    }

    private void setupUi() {
        Assets assets = this.mGame.getAssets();
        UiBuilder builder = UiUtils.createUiBuilder(assets);
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/selectvehicle.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        Menu menu = (Menu)builder.getActor("menu");
        this.mVehicleNameLabel = (Label)builder.getActor("vehicleNameLabel");
        this.mUnlockHintLabel = (Label)builder.getActor("unlockHintLabel");
        this.createVehicleSelector(builder, menu);
        this.updateVehicleDetails((VehicleDef)this.mVehicleSelector.getCurrent());
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectVehicleScreen.this.onBackPressed();
            }
        });
        this.mNextButton = menu.addNextButton();
        this.mNextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectVehicleScreen.this.next();
            }
        });
        this.updateNextButton();
    }

    private void createVehicleSelector(UiBuilder builder, Menu menu) {
        Assets assets = this.mGame.getAssets();
        this.mVehicleSelector = new VehicleSelector(menu);
        this.mVehicleSelector.setMenuStyle(menu.getMenuStyleByName("large"));
        this.mVehicleSelector.init(assets, this.mGame.getRewardManager());
        this.mVehicleSelector.setColumnCount(builder.getIntConfigValue("columnCount"));
        this.mVehicleSelector.setItemSize(builder.getIntConfigValue("itemWidth"), builder.getIntConfigValue("itemHeight"));
        String id = this.mGame.getConfig().vehicles[0];
        this.mVehicleSelector.setCurrent(assets.findVehicleDefById(id));
        menu.addItem(this.mVehicleSelector);
        this.mVehicleSelector.setSelectionListener(new GridMenuItem.SelectionListener<VehicleDef>(){

            @Override
            public void currentChanged(VehicleDef vehicle, int index) {
                SelectVehicleScreen.this.updateVehicleDetails(vehicle);
                SelectVehicleScreen.this.updateNextButton();
            }

            @Override
            public void selectionConfirmed() {
                SelectVehicleScreen.this.next();
            }
        });
    }

    private void updateNextButton() {
        this.mNextButton.setDisabled(!this.mVehicleSelector.isCurrentItemEnabled());
    }

    private void updateVehicleDetails(VehicleDef vehicle) {
        String text;
        if (this.mGame.getRewardManager().isVehicleUnlocked(vehicle)) {
            text = vehicle.getName();
            this.mUnlockHintLabel.setVisible(false);
        } else {
            text = StringUtils.format(Translator.tr("[Locked]"), new Object[0]);
            this.mUnlockHintLabel.setVisible(true);
            this.mUnlockHintLabel.setText(this.mGame.getRewardManager().getUnlockText(vehicle));
        }
        this.mVehicleNameLabel.setText(text);
        this.mVehicleNameLabel.pack();
    }

    @Override
    public void onBackPressed() {
        this.mListener.onBackPressed();
    }

    private void next() {
        if (!this.mVehicleSelector.isCurrentItemEnabled()) {
            return;
        }
        VehicleDef vehicleDef = (VehicleDef)this.mVehicleSelector.getCurrent();
        GameInfo.Player player = new GameInfo.Player(0, vehicleDef.id);
        this.mListener.onPlayerSelected(player);
    }

    public static interface Listener {
        public void onBackPressed();

        public void onPlayerSelected(GameInfo.Player var1);
    }
}

