/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;

public class PlatformUtils {
    private static UiType sUiType;
    private static Impl sImpl;

    public static void setup(Impl impl) {
        sImpl = impl;
    }

    public static boolean isTouchUi() {
        PlatformUtils.init();
        return sUiType == UiType.TOUCH;
    }

    public static boolean isDesktop() {
        switch (Gdx.app.getType()) {
            case Desktop: 
            case HeadlessDesktop: 
            case Applet: 
            case WebGL: {
                return true;
            }
        }
        return false;
    }

    public static void openURI(String uri) {
        sImpl.openURI(uri);
    }

    private static void init() {
        if (sUiType != null) {
            return;
        }
        String envValue = System.getenv("AGC_UI_TYPE");
        if (envValue == null) {
            sUiType = PlatformUtils.isDesktop() ? UiType.BUTTONS : UiType.TOUCH;
        } else {
            sUiType = UiType.valueOf(envValue);
            NLog.d("Forcing UI type to %s", new Object[]{sUiType});
        }
        NLog.i("UI type: %s", new Object[]{sUiType});
    }

    static {
        sImpl = new DefaultImpl();
    }

    public static interface Impl {
        public void openURI(String var1);
    }

    private static enum UiType {
        BUTTONS,
        TOUCH;

    }

    private static class DefaultImpl
    implements Impl {
        private DefaultImpl() {
        }

        @Override
        public void openURI(String uri) {
            Gdx.net.openURI(uri);
        }
    }
}

