/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.SSLLogger;

final class Utilities {
    static final char[] hexDigits = "0123456789ABCDEF".toCharArray();
    private static final String indent = "  ";
    private static final Pattern lineBreakPatern = Pattern.compile("\\r\\n|\\n|\\r");

    Utilities() {
    }

    static List<SNIServerName> addToSNIServerNameList(List<SNIServerName> list, String string) {
        SNIHostName sNIHostName = Utilities.rawToSNIHostName(string);
        if (sNIHostName == null) {
            return list;
        }
        int n = list.size();
        ArrayList<SNIServerName> arrayList = n != 0 ? new ArrayList<SNIServerName>(list) : new ArrayList(1);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            SNIServerName sNIServerName = (SNIServerName)arrayList.get(i);
            if (sNIServerName.getType() != 0) continue;
            arrayList.set(i, sNIHostName);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("the previous server name in SNI (" + sNIServerName + ") was replaced with (" + sNIHostName + ")", new Object[0]);
            }
            bl = true;
            break;
        }
        if (!bl) {
            arrayList.add(sNIHostName);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static SNIHostName rawToSNIHostName(String string) {
        SNIHostName sNIHostName;
        block3: {
            sNIHostName = null;
            if (!(string == null || string.indexOf(46) <= 0 || string.endsWith(".") || IPAddressUtil.isIPv4LiteralAddress(string) || IPAddressUtil.isIPv6LiteralAddress(string))) {
                try {
                    sNIHostName = new SNIHostName(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block3;
                    SSLLogger.fine(string + "\" is not a legal HostName for  server name indication", new Object[0]);
                }
            }
        }
        return sNIHostName;
    }

    static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = GetPropertyAction.privilegedGetProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("Value of " + string + " must either be 'true' or 'false'");
    }

    static String indent(String string) {
        return Utilities.indent(string, indent);
    }

    static String indent(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            stringBuilder.append("\n" + string2 + "<blank message>");
        } else {
            String[] stringArray = lineBreakPatern.split(string);
            boolean bl = true;
            for (String string3 : stringArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(string2).append(string3);
            }
        }
        return stringBuilder.toString();
    }

    static String toHexString(byte by) {
        return String.valueOf(hexDigits[by >> 4 & 0xF]) + String.valueOf(hexDigits[by & 0xF]);
    }

    static String byte16HexString(int n) {
        return "0x" + hexDigits[n >> 12 & 0xF] + hexDigits[n >> 8 & 0xF] + hexDigits[n >> 4 & 0xF] + hexDigits[n & 0xF];
    }

    static String toHexString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        boolean bl = true;
        for (byte by : byArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(hexDigits[by >> 4 & 0xF]);
            stringBuilder.append(hexDigits[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    static String toHexString(long l) {
        StringBuilder stringBuilder = new StringBuilder(128);
        boolean bl = true;
        do {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(hexDigits[(int)(l & 0xFL)]);
            stringBuilder.append(hexDigits[(int)((l >>>= 4) & 0xFL)]);
        } while ((l >>>= 4) != 0L);
        stringBuilder.reverse();
        return stringBuilder.toString();
    }

    static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            int n = byArray.length - 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    static boolean equals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        Utilities.rangeCheck(byArray.length, n, n2);
        Utilities.rangeCheck(byArray2.length, n3, n4);
        int n5 = n2 - n;
        int n6 = n4 - n3;
        if (n5 != n6) {
            return false;
        }
        for (int i = 0; i < n5; ++i) {
            if (byArray[i + n] == byArray2[i + n3]) continue;
            return false;
        }
        return true;
    }
}

