/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;

abstract class P11KeyFactory
extends KeyFactorySpi {
    final Token token;
    final String algorithm;

    P11KeyFactory(Token token, String string) {
        this.token = token;
        this.algorithm = string;
    }

    static P11Key convertKey(Token token, Key key, String string) throws InvalidKeyException {
        return (P11Key)token.getKeyFactory(string).engineTranslateKey(key);
    }

    @Override
    protected final <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        P11Key p11Key;
        this.token.ensureValid();
        if (key == null || clazz == null) {
            throw new InvalidKeySpecException("key and keySpec must not be null");
        }
        if (PKCS8EncodedKeySpec.class.isAssignableFrom(clazz) || X509EncodedKeySpec.class.isAssignableFrom(clazz)) {
            try {
                return this.implGetSoftwareFactory().getKeySpec(key, clazz);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidKeySpecException("Could not encode key", generalSecurityException);
            }
        }
        try {
            p11Key = (P11Key)this.engineTranslateKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Could not convert key", invalidKeyException);
        }
        Session[] sessionArray = new Session[1];
        try {
            if (p11Key.isPublic()) {
                T t = this.implGetPublicKeySpec(p11Key, clazz, sessionArray);
                return t;
            }
            T t = this.implGetPrivateKeySpec(p11Key, clazz, sessionArray);
            return t;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not generate KeySpec", pKCS11Exception);
        }
        finally {
            sessionArray[0] = this.token.releaseSession(sessionArray[0]);
        }
    }

    @Override
    protected final Key engineTranslateKey(Key key) throws InvalidKeyException {
        P11Key p11Key;
        this.token.ensureValid();
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (!key.getAlgorithm().equals(this.algorithm)) {
            throw new InvalidKeyException("Key algorithm must be " + this.algorithm);
        }
        if (key instanceof P11Key) {
            p11Key = (P11Key)key;
            if (p11Key.token == this.token) {
                return key;
            }
        }
        if ((p11Key = this.token.privateCache.get(key)) != null) {
            return p11Key;
        }
        if (key instanceof PublicKey) {
            PublicKey publicKey = this.implTranslatePublicKey((PublicKey)key);
            this.token.privateCache.put(key, (P11Key)((Object)publicKey));
            return publicKey;
        }
        if (key instanceof PrivateKey) {
            PrivateKey privateKey = this.implTranslatePrivateKey((PrivateKey)key);
            this.token.privateCache.put(key, (P11Key)((Object)privateKey));
            return privateKey;
        }
        throw new InvalidKeyException("Key must be instance of PublicKey or PrivateKey");
    }

    abstract <T extends KeySpec> T implGetPublicKeySpec(P11Key var1, Class<T> var2, Session[] var3) throws PKCS11Exception, InvalidKeySpecException;

    abstract <T extends KeySpec> T implGetPrivateKeySpec(P11Key var1, Class<T> var2, Session[] var3) throws PKCS11Exception, InvalidKeySpecException;

    abstract PublicKey implTranslatePublicKey(PublicKey var1) throws InvalidKeyException;

    abstract PrivateKey implTranslatePrivateKey(PrivateKey var1) throws InvalidKeyException;

    abstract KeyFactory implGetSoftwareFactory() throws GeneralSecurityException;
}

