/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.rewards;

import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.utils.Assert;
import java.util.HashMap;

public class Reward {
    private static final HashMap<Object, Reward> sInstances = new HashMap();
    public final Object prize;

    private Reward(Object prize) {
        this.prize = prize;
    }

    public String toString() {
        return "reward(" + this.prize.toString() + ")";
    }

    private static Reward internalGet(Object object) {
        Assert.check(object != null, "Can't find or create a reward for a null object", new Object[0]);
        Reward reward = sInstances.get(object);
        if (reward == null) {
            reward = new Reward(object);
            sInstances.put(object, reward);
        }
        return reward;
    }

    public static Reward get(Championship championship) {
        return Reward.internalGet(championship);
    }

    public static Reward get(VehicleDef vehicleDef) {
        return Reward.internalGet(vehicleDef);
    }
}

