/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.sound;

import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.concurrent.ArrayBlockingQueue;

public class SoundThreadManager
implements Runnable {
    private static final int MESSAGE_QUEUE_SIZE = 80;
    private final Thread mThread = new Thread(this);
    private final ThreadData mThreadData = new ThreadData();
    private final ArrayBlockingQueue<Message> mMessageQueue = new ArrayBlockingQueue(80);
    private long mNextPlayId = 0L;

    public SoundThreadManager() {
        Gdx.app.addLifecycleListener(new LifecycleListener(){

            @Override
            public void pause() {
            }

            @Override
            public void resume() {
            }

            @Override
            public void dispose() {
                SoundThreadManager.this.shutdownThread();
            }
        });
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: while (true) {
            Message message;
            try {
                message = this.mMessageQueue.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            switch (message.type) {
                case SHUTDOWN: {
                    NLog.i("stopped", new Object[0]);
                    return;
                }
                case PLAY_AND_FORGET: {
                    message.sound.play(message.volume, 1.0f, 0.0f);
                    break;
                }
                case PLAY: {
                    PlayingSound pSound = PlayingSound.sPool.obtain();
                    pSound.playId = message.playId;
                    pSound.sound = message.sound;
                    pSound.internalId = message.sound.play(message.volume, message.pitch, 0.0f);
                    this.mThreadData.playingSounds.add(pSound);
                    break;
                }
                case LOOP: {
                    PlayingSound pSound = PlayingSound.sPool.obtain();
                    pSound.playId = message.playId;
                    pSound.sound = message.sound;
                    pSound.internalId = message.sound.loop(message.volume, message.pitch, 0.0f);
                    this.mThreadData.playingSounds.add(pSound);
                    break;
                }
                case STOP: {
                    PlayingSound pSound = this.mThreadData.takeSound(message.playId);
                    if (pSound == null) {
                        NLog.e("Invalid playId: %d", message.playId);
                        continue block14;
                    }
                    pSound.sound.stop(pSound.internalId);
                    PlayingSound.sPool.free(pSound);
                    break;
                }
                case SET_VOLUME: {
                    PlayingSound pSound = this.mThreadData.findSound(message.playId);
                    if (pSound == null) {
                        NLog.e("Invalid playId: %d", message.playId);
                        continue block14;
                    }
                    pSound.sound.setVolume(pSound.internalId, message.volume);
                    break;
                }
                case SET_PITCH: {
                    PlayingSound pSound = this.mThreadData.findSound(message.playId);
                    if (pSound == null) {
                        NLog.e("Invalid playId: %d", message.playId);
                        continue block14;
                    }
                    pSound.sound.setPitch(pSound.internalId, message.pitch);
                    break;
                }
            }
            Pool<Message> pool = Message.sPool;
            synchronized (pool) {
                Message.sPool.free(message);
            }
        }
    }

    public void playAndForget(Sound sound, float volume) {
        Message message = this.obtainMessage();
        message.type = Message.Type.PLAY_AND_FORGET;
        message.sound = sound;
        message.volume = volume;
        this.queueMessage(message);
    }

    public long play(Sound sound, float volume) {
        return this.play(sound, volume, 1.0f);
    }

    public long play(Sound sound, float volume, float pitch) {
        return this.internalPlay(sound, volume, pitch, false);
    }

    public long loop(Sound sound, float volume, float pitch) {
        return this.internalPlay(sound, volume, pitch, true);
    }

    public void stop(long playId) {
        Message message = this.obtainMessage();
        message.type = Message.Type.STOP;
        message.playId = playId;
        this.queueMessage(message);
    }

    public void setVolume(long playId, float volume) {
        Message message = this.obtainMessage();
        message.type = Message.Type.SET_VOLUME;
        message.playId = playId;
        message.volume = volume;
        this.queueMessage(message);
    }

    public void setPitch(long playId, float pitch) {
        Message message = this.obtainMessage();
        message.type = Message.Type.SET_PITCH;
        message.playId = playId;
        message.pitch = pitch;
        this.queueMessage(message);
    }

    private long internalPlay(Sound sound, float volume, float pitch, boolean loop) {
        long playId = this.mNextPlayId++;
        Message message = this.obtainMessage();
        message.type = loop ? Message.Type.LOOP : Message.Type.PLAY;
        message.playId = playId;
        message.sound = sound;
        message.volume = volume;
        message.pitch = pitch;
        if (!this.queueMessage(message)) {
            return -1L;
        }
        return playId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message obtainMessage() {
        Pool<Message> pool = Message.sPool;
        synchronized (pool) {
            return Message.sPool.obtain();
        }
    }

    private boolean queueMessage(Message message) {
        if (this.mMessageQueue.offer(message)) {
            return true;
        }
        if (message.type != Message.Type.STOP) {
            NLog.e("Sound message queue is full, discarding message", new Object[0]);
            return false;
        }
        NLog.e("Sound message queue is full, blocking to send a STOP message", new Object[0]);
        try {
            this.mMessageQueue.put(message);
        }
        catch (InterruptedException e) {
            NLog.e("Interrupted while putting a STOP message", new Object[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void shutdownThread() {
        Message message = this.obtainMessage();
        message.type = Message.Type.SHUTDOWN;
        this.queueMessage(message);
        try {
            this.mThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class ThreadData {
        final Array<PlayingSound> playingSounds = new Array(false, 16);

        private ThreadData() {
        }

        PlayingSound findSound(long playId) {
            int idx = this.findSoundIndex(playId);
            return idx >= 0 ? this.playingSounds.get(idx) : null;
        }

        PlayingSound takeSound(long playId) {
            int idx = this.findSoundIndex(playId);
            return idx >= 0 ? this.playingSounds.removeIndex(idx) : null;
        }

        private int findSoundIndex(long playId) {
            int n = this.playingSounds.size;
            for (int idx = 0; idx < n; ++idx) {
                if (this.playingSounds.get((int)idx).playId != playId) continue;
                return idx;
            }
            return -1;
        }
    }

    private static class Message {
        public Type type;
        public long playId;
        public Sound sound;
        public float volume;
        public float pitch;
        static final Pool<Message> sPool = new Pool<Message>(){

            @Override
            protected Message newObject() {
                return new Message();
            }
        };

        private Message() {
        }

        static enum Type {
            PLAY_AND_FORGET,
            PLAY,
            LOOP,
            STOP,
            SET_VOLUME,
            SET_PITCH,
            SHUTDOWN;

        }
    }

    private static class PlayingSound {
        long playId;
        long internalId;
        Sound sound;
        static Pool<PlayingSound> sPool = new Pool<PlayingSound>(){

            @Override
            protected PlayingSound newObject() {
                return new PlayingSound();
            }
        };

        private PlayingSound() {
        }
    }
}

