/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.RangeMenuItem;
import com.agateau.utils.Assert;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;

public class SelectorMenuItem<T>
extends RangeMenuItem {
    private HorizontalGroup mGroup;
    private Image mMainImage;
    private Label mMainLabel;
    private final Array<Entry<T>> mEntries = new Array();
    private int mCurrentIndex = 0;

    public SelectorMenuItem(Menu menu) {
        super(menu);
    }

    @Override
    protected Actor createMainActor(Menu menu) {
        this.mGroup = new HorizontalGroup();
        this.mGroup.align(1);
        this.mMainImage = new Image();
        this.mMainLabel = new Label((CharSequence)"", menu.getSkin());
        this.mMainLabel.setAlignment(1);
        this.mGroup.addActor(this.mMainImage);
        this.mGroup.space(12.0f);
        this.mGroup.addActor(this.mMainLabel);
        return this.mGroup;
    }

    @Override
    public void updateMainActor() {
        if (this.mMainLabel == null) {
            return;
        }
        if (this.mEntries.size == 0) {
            return;
        }
        Entry<T> entry = this.mEntries.get(this.mCurrentIndex);
        this.mMainImage.setDrawable(entry.drawable);
        this.mMainLabel.setText(entry.text);
        this.mGroup.pack();
    }

    @Override
    protected void decrease() {
        if (this.mCurrentIndex > 0) {
            this.setCurrentIndex(this.mCurrentIndex - 1);
        } else {
            this.setCurrentIndex(this.mEntries.size - 1);
        }
    }

    @Override
    protected void increase() {
        if (this.mCurrentIndex < this.mEntries.size - 1) {
            this.setCurrentIndex(this.mCurrentIndex + 1);
        } else {
            this.setCurrentIndex(0);
        }
    }

    public void addEntry(String text, T data) {
        this.addEntry(null, text, data);
    }

    public void addEntry(Drawable drawable, String text, T data) {
        this.mEntries.add(new Entry<T>(drawable, text, data));
    }

    public T getCurrentData() {
        Entry<T> entry = this.mEntries.get(this.mCurrentIndex);
        return entry.data;
    }

    public void setCurrentData(T data) {
        for (int idx = 0; idx < this.mEntries.size; ++idx) {
            if (!this.mEntries.get((int)idx).data.equals(data)) continue;
            this.setCurrentIndex(idx);
            return;
        }
        this.setCurrentIndex(0);
    }

    private void setCurrentIndex(int currentIndex) {
        this.mCurrentIndex = currentIndex;
        this.updateMainActor();
    }

    private static class Entry<T> {
        final Drawable drawable;
        final String text;
        final T data;

        Entry(Drawable drawable, String text, T data) {
            Assert.check(data != null, "data must not be null", new Object[0]);
            this.drawable = drawable;
            this.text = text;
            this.data = data;
        }
    }
}

