/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.obstacles.tiled;

import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.obstacles.tiled.RectangleDef;
import com.agateau.pixelwheels.obstacles.tiled.TiledObstacleDef;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.math.Rectangle;

class FullObstacleCreator {
    final boolean[][] mCells;
    private final TiledObstacleDef mFullObstacleDef = new TiledObstacleDef(){

        @Override
        public void create(GameWorld world, int col, int row, int tileSize, TiledMapTileLayer.Cell cell) {
            FullObstacleCreator.this.mCells[col][row] = true;
        }
    };

    public FullObstacleCreator(int width, int height) {
        this.mCells = new boolean[width][height];
    }

    public TiledObstacleDef getObstacleDef() {
        return this.mFullObstacleDef;
    }

    public void create(GameWorld world, int tileSize) {
        int width = this.mCells.length;
        int height = this.mCells[0].length;
        Rectangle rect = new Rectangle();
        rect.x = -0.5f;
        rect.y = -0.5f;
        int startTx = -1;
        for (int ty = 0; ty < height; ++ty) {
            for (int tx = 0; tx <= width; ++tx) {
                boolean filled;
                boolean bl = filled = tx < width && this.mCells[tx][ty];
                if (startTx >= 0) {
                    int endTy;
                    if (filled) continue;
                    for (endTy = ty + 1; endTy < height && this.isRowSpanFilled(startTx, tx, endTy); ++endTy) {
                        this.clearRowSpan(startTx, tx, endTy);
                    }
                    rect.width = tx - startTx;
                    rect.height = endTy - ty;
                    RectangleDef.createRectangle(world, startTx, ty, tileSize, rect);
                    startTx = -1;
                    continue;
                }
                if (!filled) continue;
                startTx = tx;
            }
        }
    }

    private boolean isRowSpanFilled(int startTx, int endTx, int ty) {
        for (int tx = startTx; tx < endTx; ++tx) {
            if (this.mCells[tx][ty]) continue;
            return false;
        }
        return true;
    }

    private void clearRowSpan(int startTx, int endTx, int ty) {
        for (int tx = startTx; tx < endTx; ++tx) {
            this.mCells[tx][ty] = false;
        }
    }
}

