/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.utils;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.World;

public class ArcClosestBodyFinder
implements RayCastCallback {
    private static final float ANGLE_BETWEEN_RAYS = 3.0f;
    private final float mDepth;
    private final float mArc;
    private BodyFilter mBodyFilter = sDefaultBodyFilter;
    private Body mBody;
    private float mFraction;
    private static BodyFilter sDefaultBodyFilter = body -> FilterResult.STOP_SUCCESS;
    private final Vector2 mTmp = new Vector2();

    public ArcClosestBodyFinder(float depth) {
        this(depth, 0.0f);
    }

    public ArcClosestBodyFinder(float depth, float arc) {
        this.mDepth = depth;
        this.mArc = arc;
    }

    public void setBodyFilter(BodyFilter bodyFilter) {
        this.mBodyFilter = bodyFilter;
    }

    public Body find(World world, Vector2 origin, float angle) {
        this.mFraction = 1.0f;
        this.mBody = null;
        for (float a = angle - this.mArc / 2.0f; a <= angle + this.mArc / 2.0f; a += 3.0f) {
            this.mTmp.set(this.mDepth, 0.0f).rotate(a).add(origin);
            world.rayCast(this, origin, this.mTmp);
        }
        return this.mBody;
    }

    public Vector2 getLeftVertex(Vector2 origin, float angle) {
        this.mTmp.set(this.mDepth, 0.0f).rotate(angle + this.mArc / 2.0f).add(origin);
        return this.mTmp;
    }

    public Vector2 getRightVertex(Vector2 origin, float angle) {
        this.mTmp.set(this.mDepth, 0.0f).rotate(angle - this.mArc / 2.0f).add(origin);
        return this.mTmp;
    }

    @Override
    public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
        if (this.mFraction < fraction) {
            return this.mFraction;
        }
        Body body = fixture.getBody();
        switch (this.mBodyFilter.filter(body)) {
            case IGNORE: {
                return -1.0f;
            }
            case STOP_FAILED: {
                return 0.0f;
            }
            case STOP_SUCCESS: {
                this.mFraction = fraction;
                this.mBody = body;
            }
        }
        return fraction;
    }

    public static interface BodyFilter {
        public FilterResult filter(Body var1);
    }

    public static enum FilterResult {
        IGNORE,
        STOP_FAILED,
        STOP_SUCCESS;

    }
}

