/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class PSSParameters
extends AlgorithmParametersSpi {
    private PSSParameterSpec spec;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
        String string = pSSParameterSpec.getMGFAlgorithm();
        if (!pSSParameterSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
            throw new InvalidParameterSpecException("Unsupported mgf " + string + "; MGF1 only");
        }
        AlgorithmParameterSpec algorithmParameterSpec2 = pSSParameterSpec.getMGFParameters();
        if (!(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate mgf parameters; non-null MGF1ParameterSpec only");
        }
        this.spec = pSSParameterSpec;
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        DerValue[] derValueArray;
        String string = PSSParameterSpec.DEFAULT.getDigestAlgorithm();
        MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)PSSParameterSpec.DEFAULT.getMGFParameters();
        int n = PSSParameterSpec.DEFAULT.getSaltLength();
        int n2 = PSSParameterSpec.DEFAULT.getTrailerField();
        DerInputStream derInputStream = new DerInputStream(byArray);
        for (DerValue derValue : derValueArray = derInputStream.getSequence(4)) {
            if (derValue.isContextSpecific((byte)0)) {
                string = AlgorithmId.parse(derValue.data.getDerValue()).getName();
                continue;
            }
            if (derValue.isContextSpecific((byte)1)) {
                String string2;
                AlgorithmId algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
                if (!algorithmId.getOID().equals(AlgorithmId.mgf1_oid)) {
                    throw new IOException("Only MGF1 mgf is supported");
                }
                AlgorithmId algorithmId2 = AlgorithmId.parse(new DerValue(algorithmId.getEncodedParams()));
                switch (string2 = algorithmId2.getName()) {
                    case "SHA-1": {
                        mGF1ParameterSpec = MGF1ParameterSpec.SHA1;
                        break;
                    }
                    case "SHA-224": {
                        mGF1ParameterSpec = MGF1ParameterSpec.SHA224;
                        break;
                    }
                    case "SHA-256": {
                        mGF1ParameterSpec = MGF1ParameterSpec.SHA256;
                        break;
                    }
                    case "SHA-384": {
                        mGF1ParameterSpec = MGF1ParameterSpec.SHA384;
                        break;
                    }
                    case "SHA-512": {
                        mGF1ParameterSpec = MGF1ParameterSpec.SHA512;
                        break;
                    }
                    case "SHA-512/224": {
                        mGF1ParameterSpec = MGF1ParameterSpec.SHA512_224;
                        break;
                    }
                    case "SHA-512/256": {
                        mGF1ParameterSpec = MGF1ParameterSpec.SHA512_256;
                        break;
                    }
                    default: {
                        throw new IOException("Unrecognized message digest algorithm " + string2);
                    }
                }
                continue;
            }
            if (derValue.isContextSpecific((byte)2)) {
                n = derValue.data.getDerValue().getInteger();
                if (n >= 0) continue;
                throw new IOException("Negative value for saltLength");
            }
            if (derValue.isContextSpecific((byte)3)) {
                n2 = derValue.data.getDerValue().getInteger();
                if (n2 == 1) continue;
                throw new IOException("Unsupported trailerField value " + n2);
            }
            throw new IOException("Invalid encoded PSSParameters");
        }
        this.spec = new PSSParameterSpec(string, "MGF1", mGF1ParameterSpec, n, n2);
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (PSSParameterSpec.class.isAssignableFrom(clazz)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(this.spec));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return PSSParameters.getEncoded(this.spec);
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string != null && !string.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return this.spec.toString();
    }

    public static byte[] getEncoded(PSSParameterSpec pSSParameterSpec) throws IOException {
        AlgorithmId algorithmId;
        DerOutputStream derOutputStream;
        AlgorithmId algorithmId2;
        AlgorithmParameterSpec algorithmParameterSpec = pSSParameterSpec.getMGFParameters();
        if (!(algorithmParameterSpec instanceof MGF1ParameterSpec)) {
            throw new IOException("Cannot encode " + algorithmParameterSpec);
        }
        MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)algorithmParameterSpec;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        try {
            algorithmId2 = AlgorithmId.get(pSSParameterSpec.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("AlgorithmId " + pSSParameterSpec.getDigestAlgorithm() + " impl not found");
        }
        if (!algorithmId2.getOID().equals(AlgorithmId.SHA_oid)) {
            derOutputStream = new DerOutputStream();
            algorithmId2.derEncode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        try {
            algorithmId = AlgorithmId.get(mGF1ParameterSpec.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("AlgorithmId " + mGF1ParameterSpec.getDigestAlgorithm() + " impl not found");
        }
        if (!algorithmId.getOID().equals(AlgorithmId.SHA_oid)) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOID(AlgorithmId.mgf1_oid);
            algorithmId.encode(derOutputStream);
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.write((byte)48, derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream3);
        }
        if (pSSParameterSpec.getSaltLength() != 20) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(pSSParameterSpec.getSaltLength());
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream);
        }
        if (pSSParameterSpec.getTrailerField() != 1) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(pSSParameterSpec.getTrailerField());
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
        }
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream2);
        return derOutputStream4.toByteArray();
    }
}

