/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.CharBuffer;
import java.util.Spliterator;
import java.util.function.IntConsumer;

class CharBufferSpliterator
implements Spliterator.OfInt {
    private final CharBuffer buffer;
    private int index;
    private final int limit;

    CharBufferSpliterator(CharBuffer charBuffer) {
        this(charBuffer, charBuffer.position(), charBuffer.limit());
    }

    CharBufferSpliterator(CharBuffer charBuffer, int n, int n2) {
        assert (n <= n2);
        this.buffer = charBuffer;
        this.index = n <= n2 ? n : n2;
        this.limit = n2;
    }

    @Override
    public Spliterator.OfInt trySplit() {
        CharBufferSpliterator charBufferSpliterator;
        int n = this.index;
        int n2 = n + this.limit >>> 1;
        if (n >= n2) {
            charBufferSpliterator = null;
        } else {
            this.index = n2;
            CharBufferSpliterator charBufferSpliterator2 = new CharBufferSpliterator(this.buffer, n, this.index);
            charBufferSpliterator = charBufferSpliterator2;
        }
        return charBufferSpliterator;
    }

    @Override
    public void forEachRemaining(IntConsumer intConsumer) {
        int n;
        if (intConsumer == null) {
            throw new NullPointerException();
        }
        CharBuffer charBuffer = this.buffer;
        int n2 = this.index;
        this.index = n = this.limit;
        while (n2 < n) {
            intConsumer.accept(charBuffer.getUnchecked(n2++));
        }
    }

    @Override
    public boolean tryAdvance(IntConsumer intConsumer) {
        if (intConsumer == null) {
            throw new NullPointerException();
        }
        if (this.index >= 0 && this.index < this.limit) {
            intConsumer.accept(this.buffer.getUnchecked(this.index++));
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.limit - this.index;
    }

    @Override
    public int characteristics() {
        return 16464;
    }
}

