/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.map.LapPosition;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.utils.log.NLog;

public class LapPositionComponent
implements Racer.Component {
    private final Track mTrack;
    private final Vehicle mVehicle;
    private float mBestLapTime = -1.0f;
    private float mTotalTime = 0.0f;
    private float mLapTime = 0.0f;
    private int mLapCount = 0;
    private final LapPosition mLapPosition = new LapPosition();
    private Status mStatus = Status.RACING;
    private boolean mSkipNextFinishLine = true;

    public LapPositionComponent(Track track, Vehicle vehicle) {
        this.mTrack = track;
        this.mVehicle = vehicle;
    }

    @Override
    public void act(float delta) {
        if (this.mStatus != Status.RACING) {
            return;
        }
        this.mTotalTime += delta;
        this.mLapTime += delta;
        this.updatePosition();
    }

    public float getBestLapTime() {
        return this.mBestLapTime;
    }

    public float getTotalTime() {
        return this.mTotalTime;
    }

    public int getLapCount() {
        return this.mLapCount;
    }

    public float getLapDistance() {
        return this.mLapPosition.getLapDistance();
    }

    public boolean hasFinishedRace() {
        return this.mStatus != Status.RACING;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    private void updatePosition() {
        boolean crossedFinishLineBackward;
        int oldSectionId = this.mLapPosition.getSectionId();
        float PFU = 20.0f;
        int pixelX = (int)(20.0f * this.mVehicle.getX());
        int pixelY = (int)(20.0f * this.mVehicle.getY());
        LapPosition pos = this.mTrack.getLapPositionTable().get(pixelX, pixelY);
        if (pos == null) {
            NLog.e("No LapPosition at pixel " + pixelX + " x " + pixelY, new Object[0]);
            return;
        }
        this.mLapPosition.copy(pos);
        boolean crossedFinishLine = this.mLapPosition.getSectionId() == 0 && oldSectionId > 1;
        boolean bl = crossedFinishLineBackward = this.mLapPosition.getSectionId() > 1 && oldSectionId == 0;
        if (crossedFinishLine) {
            if (this.mSkipNextFinishLine) {
                this.mSkipNextFinishLine = false;
            } else {
                this.onLapCompleted();
            }
            ++this.mLapCount;
            if (this.mLapCount > this.mTrack.getTotalLapCount()) {
                --this.mLapCount;
                this.mStatus = Status.COMPLETED;
            }
        } else if (crossedFinishLineBackward) {
            --this.mLapCount;
            this.mSkipNextFinishLine = true;
        }
    }

    private void onLapCompleted() {
        if (!this.hasBestLapTime() || this.mLapTime < this.mBestLapTime) {
            this.mBestLapTime = this.mLapTime;
        }
        this.mLapTime = 0.0f;
    }

    public void fakeCompletion(float fakeTotalTime) {
        float fakeBestLapTime = fakeTotalTime * 0.98f / (float)this.mTrack.getTotalLapCount();
        if (!this.hasBestLapTime() || fakeBestLapTime < this.mBestLapTime) {
            this.mBestLapTime = fakeBestLapTime;
        }
        this.mStatus = Status.COMPLETED;
        this.mLapCount = this.mTrack.getTotalLapCount();
        this.mTotalTime = fakeTotalTime;
    }

    public void markRaceFinished() {
        if (this.mStatus != Status.RACING) {
            return;
        }
        if (this.mLapCount == 0) {
            this.mTotalTime = Float.MAX_VALUE;
            this.mBestLapTime = this.mTotalTime / (float)this.mTrack.getTotalLapCount();
            this.mStatus = Status.DID_NOT_START;
            return;
        }
        float lapPercent = 1.0f / (float)this.mTrack.getTotalLapCount();
        float lastLapPercent = this.mLapPosition.getLapDistance() / (float)this.mTrack.getLapPositionTable().getSectionCount() * lapPercent;
        float percentageDone = (float)(this.mLapCount - 1) * lapPercent + lastLapPercent;
        this.fakeCompletion(this.mTotalTime / percentageDone);
    }

    private boolean hasBestLapTime() {
        return this.mBestLapTime > 0.0f;
    }

    public static enum Status {
        RACING,
        COMPLETED,
        DID_NOT_START;

    }
}

