/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.gameinput.GameInput;
import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.InputMapperInputHandler;
import com.agateau.pixelwheels.racer.Pilot;
import com.agateau.pixelwheels.racer.Probe;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.ui.InputMapper;
import com.agateau.ui.VirtualKey;

public class PlayerPilot
implements Pilot {
    private final Assets mAssets;
    private final GameWorld mGameWorld;
    private final Racer mRacer;
    private final GameConfig mGameConfig;
    private final int mPlayerIndex;
    private GameInputHandler mInputHandler;
    private boolean mLastTriggering = false;
    private Probe mSpeedReportProbe;

    public PlayerPilot(Assets assets, GameWorld gameWorld, Racer racer, GameConfig gameConfig, int playerIndex) {
        this.mAssets = assets;
        this.mGameWorld = gameWorld;
        this.mRacer = racer;
        this.mGameConfig = gameConfig;
        this.mPlayerIndex = playerIndex;
        this.updateInputHandler();
        this.mGameConfig.addListener(group -> {
            if (group == GameConfig.ConfigGroup.INPUT) {
                this.updateInputHandler();
            }
        });
    }

    public void createHudButtons(Hud hud) {
        hud.deleteInputUiContainer();
        this.mInputHandler.createHudButtons(this.mAssets, hud);
    }

    @Override
    public void act(float dt) {
        Vehicle vehicle = this.mRacer.getVehicle();
        if (this.mGameWorld.getState() == GameWorld.State.RUNNING) {
            this.mInputHandler.setBonus(this.mRacer.getBonus());
            GameInput input = this.mInputHandler.getGameInput();
            vehicle.setDirection(input.direction);
            vehicle.setAccelerating(input.accelerating);
            vehicle.setBraking(input.braking);
            if (input.triggeringBonus && !this.mLastTriggering) {
                this.mRacer.triggerBonus();
            }
            this.mLastTriggering = input.triggeringBonus;
            if (this.mSpeedReportProbe != null) {
                this.mSpeedReportProbe.addValue("left", input.leftPressed);
                this.mSpeedReportProbe.addValue("right", input.rightPressed);
            }
        }
    }

    @Override
    public GameStats getGameStats() {
        return this.mGameWorld.getGameStats();
    }

    public boolean isPauseKeyPressed() {
        if (!(this.mInputHandler instanceof InputMapperInputHandler)) {
            return false;
        }
        InputMapper inputMapper = ((InputMapperInputHandler)this.mInputHandler).getInputMapper();
        return inputMapper.isKeyJustPressed(VirtualKey.PAUSE);
    }

    private void updateInputHandler() {
        this.mInputHandler = this.mGameConfig.getPlayerInputHandler(this.mPlayerIndex);
    }

    public void setSpeedReportProbe(Probe probe) {
        this.mSpeedReportProbe = probe;
    }
}

