/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.Constants;
import com.agateau.pixelwheels.Renderer;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.gameobject.CellFrameBufferManager;
import com.agateau.pixelwheels.gameobject.CellFrameBufferUser;
import com.agateau.pixelwheels.racer.SkidmarksRenderer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.utils.BodyRegionDrawer;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.utils.Array;

public class VehicleRenderer
implements CellFrameBufferUser {
    private static final int CELL_SIZE = 200;
    private final Assets mAssets;
    private final Vehicle mVehicle;
    private final Array<Renderer> mRenderers = new Array();
    private final SkidmarksRenderer mSkidmarksRenderer;
    private float mTime = 0.0f;
    private final BodyRegionDrawer mBodyRegionDrawer = new BodyRegionDrawer();
    private CellFrameBufferManager mCellFrameBufferManager;
    private int mCellId = -1;
    private final Color mBatchColor = new Color();

    public VehicleRenderer(Assets assets, Vehicle vehicle) {
        this.mAssets = assets;
        this.mVehicle = vehicle;
        this.mSkidmarksRenderer = new SkidmarksRenderer(this.mAssets);
    }

    public void addRenderer(Renderer renderer) {
        this.mRenderers.add(renderer);
    }

    public void removeRenderer(Renderer renderer) {
        this.mRenderers.removeValue(renderer, true);
    }

    public Color getBatchColor() {
        if (this.mVehicle.isFalling()) {
            float k = MathUtils.clamp(1.0f + this.mVehicle.getZ() * 10.0f, 0.0f, 1.0f);
            this.mBatchColor.set(Constants.FULLY_IMMERSED_COLOR);
            this.mBatchColor.lerp(Color.WHITE, k);
        } else {
            this.mBatchColor.set(Color.WHITE);
        }
        return this.mBatchColor;
    }

    @Override
    public void init(CellFrameBufferManager manager) {
        this.mCellFrameBufferManager = manager;
        this.mCellId = manager.reserveCell(200, 200);
    }

    private void drawBodyToCell(Batch batch, Body body, TextureRegion region) {
        float angle = body.getAngle() * 57.295776f;
        angle = AgcMathUtils.snapAngle(angle);
        float xOffset = (body.getPosition().x - this.mVehicle.getPosition().x) / 0.05f;
        float yOffset = (body.getPosition().y - this.mVehicle.getPosition().y) / 0.05f;
        float w = region.getRegionWidth();
        float h = region.getRegionHeight();
        float x = this.mCellFrameBufferManager.getCellCenterX(this.mCellId) + xOffset;
        float y = this.mCellFrameBufferManager.getCellCenterY(this.mCellId) + yOffset;
        batch.draw(region, x - w / 2.0f, y - h / 2.0f, w / 2.0f, h / 2.0f, w, h, 1.0f, 1.0f, angle);
    }

    @Override
    public void drawToCell(Batch batch, Rectangle viewBounds) {
        this.mTime += Gdx.app.getGraphics().getDeltaTime();
        for (Vehicle.WheelInfo info : this.mVehicle.getWheelInfos()) {
            this.drawBodyToCell(batch, info.wheel.getBody(), info.wheel.getRegion());
        }
        TextureRegion region = this.mVehicle.getRegion(this.mTime);
        this.drawBodyToCell(batch, this.mVehicle.getBody(), region);
        float centerX = this.mCellFrameBufferManager.getCellCenterX(this.mCellId);
        float centerY = this.mCellFrameBufferManager.getCellCenterY(this.mCellId);
        for (Renderer renderer : this.mRenderers) {
            renderer.drawToCell(batch, centerX, centerY);
        }
    }

    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        ZLevel vehicleZLevel;
        this.mBodyRegionDrawer.setBatch(batch);
        float scale = this.mVehicle.getZ() + 1.0f;
        if (zLevel == ZLevel.GROUND) {
            for (Vehicle.WheelInfo info : this.mVehicle.getWheelInfos()) {
                this.mSkidmarksRenderer.draw(batch, info.wheel.getSkidmarks(), viewBounds);
            }
            if (!this.mVehicle.isFalling()) {
                for (Vehicle.WheelInfo info : this.mVehicle.getWheelInfos()) {
                    if (!info.wheel.getMaterial().isWater()) continue;
                    Animation<TextureRegion> splashAnimation = info.wheel.getSplashAnimation();
                    this.mBodyRegionDrawer.draw(info.wheel.getBody(), splashAnimation.getKeyFrame(this.mTime, true));
                }
                float offset = BodyRegionDrawer.computeShadowOffset(this.mVehicle.getZ(), 1.0f);
                float old = batch.getPackedColor();
                batch.setColor(0.0f, 0.0f, 0.0f, 0.35f);
                this.mCellFrameBufferManager.drawCell(batch, this.mVehicle.getX() + offset, this.mVehicle.getY() - offset, this.mCellId);
                batch.setPackedColor(old);
            }
            return;
        }
        ZLevel zLevel2 = vehicleZLevel = this.mVehicle.isFlying() ? ZLevel.FLYING_HIGH : ZLevel.ON_GROUND;
        if (zLevel == vehicleZLevel) {
            if (this.mVehicle.isFalling()) {
                batch.setColor(this.getBatchColor());
            }
            this.mCellFrameBufferManager.drawScaledCell(batch, this.mVehicle.getPosition(), this.mCellId, scale);
            if (this.mVehicle.isFalling()) {
                batch.setColor(Color.WHITE);
            }
            if (this.mVehicle.getTurboTime() >= 0.0f) {
                this.drawTurbo(batch);
            }
        }
        for (Renderer renderer : this.mRenderers) {
            renderer.draw(batch, zLevel);
        }
    }

    private void drawTurbo(Batch batch) {
        TextureRegion region = this.mAssets.turboFlame.getKeyFrame(this.mVehicle.getTurboTime(), true);
        Body body = this.mVehicle.getBody();
        Vector2 center = body.getPosition();
        float angle = body.getAngle() * 57.295776f;
        float w = 0.05f * (float)region.getRegionWidth();
        float h = 0.05f * (float)region.getRegionHeight();
        float refH = -this.mVehicle.getWidth() / 2.0f;
        float x = center.x + refH * MathUtils.cosDeg(angle);
        float y = center.y + refH * MathUtils.sinDeg(angle);
        batch.draw(region, x - w / 2.0f, y - h, w / 2.0f, h, w, h, 1.0f, 1.0f, angle - 90.0f);
    }
}

