/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.Language;
import com.agateau.pixelwheels.LogExporter;
import com.agateau.pixelwheels.LogExporterUtils;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactory;
import com.agateau.pixelwheels.screens.CreditsScreen;
import com.agateau.pixelwheels.screens.DebugScreen;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.SelectLanguageScreen;
import com.agateau.pixelwheels.screens.config.InputSelectorController;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.translations.Translator;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.ButtonMenuItem;
import com.agateau.ui.menu.LabelMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItemGroup;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.menu.SelectorMenuItem;
import com.agateau.ui.menu.SliderMenuItem;
import com.agateau.ui.menu.SwitchMenuItem;
import com.agateau.ui.menu.TabMenuItem;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.agateau.utils.PlatformUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class ConfigScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final Origin mOrigin;
    private static final String WEBSITE_URL = "https://agateau.com/projects/pixelwheels";
    Menu mMenu;
    TabMenuItem mTabMenuItem;
    MenuItemGroup mLanguageGroup;
    private boolean mLanguageChanged = false;

    public ConfigScreen(PwGame game, Origin origin) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mOrigin = origin;
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                ConfigScreen.this.mGame.replaceScreen(new ConfigScreen(ConfigScreen.this.mGame, ConfigScreen.this.mOrigin));
            }
        };
    }

    private void setupUi() {
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().atlas, this.mGame.getAssets().ui.skin);
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/config.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        this.mMenu = (Menu)builder.getActor("menu");
        this.mTabMenuItem = new TabMenuItem(this.mMenu);
        this.mMenu.addItem(this.mTabMenuItem);
        this.addAudioVideoTab();
        this.addControlsTab();
        this.addAboutTab();
        this.addInternalTab();
        this.mMenu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ConfigScreen.this.onBackPressed();
            }
        });
    }

    private void addAboutTab() {
        MenuItemGroup group = this.mTabMenuItem.addPage(Translator.tr("About"));
        group.setWidth(800.0f);
        group.addLabel(StringUtils.format(Translator.tr("Pixel Wheels %s"), "1.0.0"));
        group.addButton(Translator.tr("CREDITS")).setParentWidthRatio(0.5f).addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ConfigScreen.this.mGame.pushScreen(new CreditsScreen(ConfigScreen.this.mGame));
            }
        });
        group.addButton(Translator.tr("WEB SITE")).setParentWidthRatio(0.5f).addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                PlatformUtils.openURI(ConfigScreen.WEBSITE_URL);
            }
        });
        group.addSpacer();
    }

    private void addInternalTab() {
        MenuItemGroup group = this.mTabMenuItem.addPage(Translator.tr("Under the hood"));
        group.setWidth(800.0f);
        final LogExporter logExporter = this.mGame.getLogExporter();
        if (logExporter != null) {
            group.addLabel(logExporter.getDescription()).setWrap(true);
            group.addButton(logExporter.getActionText()).setParentWidthRatio(0.5f).addListener(new MenuItemListener(){

                @Override
                public void triggered() {
                    LogExporterUtils.exportLogs(logExporter);
                }
            });
            group.addSpacer();
        }
        group.addLabel(Translator.tr("These options are mostly interesting for Pixel Wheels development, but feel free to poke around!")).setWrap(true);
        group.addButton(Translator.tr("DEV. OPTIONS")).setParentWidthRatio(0.5f).addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ConfigScreen.this.mGame.pushScreen(new DebugScreen(ConfigScreen.this.mGame));
            }
        });
    }

    private void addControlsTab() {
        MenuItemGroup group = this.mTabMenuItem.addPage(Translator.tr("Controls"));
        group.setWidth(750.0f);
        if (!PlatformUtils.isDesktop() || Debug.instance.alwaysShowTouchInput) {
            this.setupHudZoomSlider(this.mMenu, group);
        }
        if (PlatformUtils.isDesktop()) {
            TabMenuItem tabMenuItem = new TabMenuItem(this.mMenu);
            group.addItem(tabMenuItem);
            for (int idx = 0; idx < 4; ++idx) {
                String tabText = StringUtils.format(Translator.tr("P%d"), idx + 1);
                MenuItemGroup playerGroup = tabMenuItem.addPage(tabText);
                String selectorText = StringUtils.format(Translator.tr("Player #%d:"), idx + 1);
                this.setupInputSelector(this.mMenu, playerGroup, selectorText, idx);
            }
        } else {
            this.setupInputSelector(this.mMenu, group, Translator.tr("Controls:"), 0);
        }
    }

    private void addAudioVideoTab() {
        MenuItemGroup group;
        final GameConfig gameConfig = this.mGame.getConfig();
        this.mLanguageGroup = group = this.mTabMenuItem.addPage(Translator.tr("General"));
        ButtonMenuItem languageButton = new ButtonMenuItem(this.mMenu, this.getLanguageText());
        languageButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ConfigScreen.this.mGame.pushScreen(new SelectLanguageScreen(ConfigScreen.this.mGame));
            }
        });
        group.addItemWithLabel(Translator.tr("Language:"), languageButton);
        if (this.mOrigin == Origin.PAUSE_OVERLAY) {
            languageButton.setDisabled(true);
            languageButton.setText(Translator.trc("Can't change while racing", "'change' refer to changing languages"));
        }
        group.addTitleLabel(Translator.tr("Audio"));
        final SwitchMenuItem soundFxSwitch = new SwitchMenuItem(this.mMenu);
        soundFxSwitch.setChecked(gameConfig.playSoundFx);
        soundFxSwitch.getActor().addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                gameConfig.playSoundFx = soundFxSwitch.isChecked();
                gameConfig.flush(GameConfig.ConfigGroup.OTHER);
            }
        });
        group.addItemWithLabel(Translator.tr("Sound FX:"), soundFxSwitch);
        final SwitchMenuItem musicSwitch = new SwitchMenuItem(this.mMenu);
        musicSwitch.setChecked(gameConfig.playMusic);
        musicSwitch.getActor().addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                gameConfig.playMusic = musicSwitch.isChecked();
                gameConfig.flush(GameConfig.ConfigGroup.OTHER);
            }
        });
        group.addItemWithLabel(Translator.tr("Music:"), musicSwitch);
        group.addTitleLabel(Translator.tr("Video"));
        if (PlatformUtils.isDesktop()) {
            final SwitchMenuItem fullscreenSwitch = new SwitchMenuItem(this.mMenu);
            fullscreenSwitch.setChecked(gameConfig.fullscreen);
            fullscreenSwitch.getActor().addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    gameConfig.fullscreen = fullscreenSwitch.isChecked();
                    ConfigScreen.this.mGame.setFullscreen(gameConfig.fullscreen);
                    gameConfig.flush(GameConfig.ConfigGroup.OTHER);
                }
            });
            group.addItemWithLabel(Translator.tr("Fullscreen:"), fullscreenSwitch);
        }
        final SwitchMenuItem headingUpCameraSwitch = new SwitchMenuItem(this.mMenu);
        headingUpCameraSwitch.setChecked(gameConfig.headingUpCamera);
        headingUpCameraSwitch.getActor().addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                gameConfig.headingUpCamera = headingUpCameraSwitch.isChecked();
                gameConfig.flush(GameConfig.ConfigGroup.OTHER);
            }
        });
        group.addItemWithLabel(Translator.tr("Rotate camera:"), headingUpCameraSwitch);
    }

    private String getLanguageText() {
        GameConfig gameConfig = this.mGame.getConfig();
        Language language = this.mGame.getAssets().languages.getLanguage(gameConfig.languageId);
        return language.name;
    }

    private void selectLanguageButton() {
        this.mTabMenuItem.setCurrentPage(this.mLanguageGroup);
        this.mMenu.setCurrentItem(this.mLanguageGroup);
    }

    public static ConfigScreen createAfterLanguageChange(PwGame game) {
        ConfigScreen screen = new ConfigScreen(game, Origin.MENU);
        screen.selectLanguageButton();
        screen.mLanguageChanged = true;
        return screen;
    }

    private void setupInputSelector(Menu menu, MenuItemGroup group, String label, int idx) {
        SelectorMenuItem<GameInputHandlerFactory> selector = new SelectorMenuItem<GameInputHandlerFactory>(menu);
        group.addItemWithLabel(label, selector);
        ButtonMenuItem configureButton = new ButtonMenuItem(menu, Translator.tr("CONFIGURE"));
        group.addItemWithLabel("", configureButton);
        LabelMenuItem nameLabel = new LabelMenuItem("", menu.getSkin());
        group.addItemWithLabel("", nameLabel);
        InputSelectorController controller = new InputSelectorController(this.mGame, selector, configureButton, nameLabel, idx);
        controller.setStartupState();
    }

    private void setupHudZoomSlider(Menu menu, MenuItemGroup group) {
        final SliderMenuItem zoomSlider = new SliderMenuItem(menu){

            @Override
            protected String formatValue(int value) {
                if (this.isAtMinimumValue()) {
                    return Translator.trc("Automatic", "Indicates the HUD zoom adjusts itself automatically");
                }
                return super.formatValue(value);
            }
        };
        float step = 0.2f;
        zoomSlider.setRange(1.0f - step, 3.0f, step);
        group.addItemWithLabel(Translator.tr("Zoom:"), zoomSlider);
        float value = this.mGame.getConfig().hudZoom;
        if (value == 0.0f) {
            zoomSlider.setToMinimumValue();
        } else {
            zoomSlider.setFloatValue(value);
        }
        zoomSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GameConfig config = ConfigScreen.this.mGame.getConfig();
                config.hudZoom = zoomSlider.isAtMinimumValue() ? 0.0f : zoomSlider.getFloatValue();
                config.flush(GameConfig.ConfigGroup.OTHER);
            }
        });
    }

    @Override
    public void onBackPressed() {
        this.mGame.popScreen();
        if (this.mLanguageChanged) {
            NLog.i("Language changed, recreating MainMenuScreen", new Object[0]);
            this.mGame.showMainMenu();
        }
    }

    public static enum Origin {
        MENU,
        PAUSE_OVERLAY;

    }
}

