/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gamesetup.GameMode;
import com.agateau.pixelwheels.screens.DifficultySelectorController;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItem;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class SelectGameModeScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final int mPlayerCount;

    public SelectGameModeScreen(PwGame game, int playerCount) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mPlayerCount = playerCount;
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                SelectGameModeScreen.this.mGame.replaceScreen(new SelectGameModeScreen(SelectGameModeScreen.this.mGame, SelectGameModeScreen.this.mPlayerCount));
            }
        };
    }

    private void setupUi() {
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().ui.atlas, this.mGame.getAssets().ui.skin);
        DifficultySelectorController.registerFactory(builder, this.mGame.getConfig());
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/selectgamemode.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        Menu menu = (Menu)builder.getActor("menu");
        ((Actor)builder.getActor("quickRaceButton")).addListener(new MenuItemListener(){

            @Override
            public void triggered() {
                ((SelectGameModeScreen)SelectGameModeScreen.this).mGame.getConfig().gameMode = GameMode.QUICK_RACE;
                SelectGameModeScreen.this.mGame.getConfig().flush(GameConfig.ConfigGroup.OTHER);
                SelectGameModeScreen.this.mGame.showQuickRace(SelectGameModeScreen.this.mPlayerCount);
            }
        });
        Object championshipItem = builder.getMenuItem("championshipButton");
        championshipItem.addListener(new MenuItemListener(){

            @Override
            public void triggered() {
                ((SelectGameModeScreen)SelectGameModeScreen.this).mGame.getConfig().gameMode = GameMode.CHAMPIONSHIP;
                SelectGameModeScreen.this.mGame.getConfig().flush(GameConfig.ConfigGroup.OTHER);
                SelectGameModeScreen.this.mGame.showChampionship(SelectGameModeScreen.this.mPlayerCount);
            }
        });
        if (this.mGame.getConfig().gameMode == GameMode.CHAMPIONSHIP) {
            menu.setCurrentItem((MenuItem)championshipItem);
        }
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectGameModeScreen.this.onBackPressed();
            }
        });
    }

    @Override
    public void onBackPressed() {
        this.mGame.popScreen();
    }
}

