/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Constants;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.agateau.utils.PlatformUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class SupportScreen
extends PwStageScreen {
    private static final String SUPPORT_URL = "https://agateau.com/support";
    private static final String SHOP_URL = "https://agateau.com/redirect/pw-goodies";
    private final PwGame mGame;

    public SupportScreen(PwGame game) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                SupportScreen.this.mGame.replaceScreen(new SupportScreen(SupportScreen.this.mGame));
            }
        };
    }

    private void setupUi() {
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().atlas, this.mGame.getAssets().ui.skin);
        if (Constants.STORE != Constants.Store.GPLAY) {
            builder.defineVariable("showSupportSection");
        }
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/support.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        Menu menu = (Menu)builder.getActor("menu");
        ((Actor)builder.getActor("shopButton")).addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                PlatformUtils.openURI(SupportScreen.SHOP_URL);
            }
        });
        if (Constants.STORE != Constants.Store.GPLAY) {
            ((Actor)builder.getActor("supportButton")).addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    PlatformUtils.openURI(SupportScreen.SUPPORT_URL);
                }
            });
        }
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SupportScreen.this.onBackPressed();
            }
        });
    }

    @Override
    public void onBackPressed() {
        this.mGame.popScreen();
    }
}

