/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.racescreen.Overlay;
import com.agateau.pixelwheels.racescreen.RaceScreen;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;

public class PauseOverlay
extends Overlay {
    private final PwGame mGame;
    private final RaceScreen mRaceScreen;

    public PauseOverlay(PwGame game, RaceScreen raceScreen) {
        super(game.getAssets().dot);
        this.mGame = game;
        this.mRaceScreen = raceScreen;
        new PwRefreshHelper(this.mGame, this){

            @Override
            protected void refresh() {
                PauseOverlay.this.setContent(PauseOverlay.this.createContent());
            }
        };
        this.setContent(this.createContent());
    }

    private Actor createContent() {
        boolean isQuickRace;
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().atlas, this.mGame.getAssets().ui.skin);
        boolean bl = isQuickRace = this.mRaceScreen.getGameType() == GameInfo.GameType.QUICK_RACE;
        if (isQuickRace) {
            builder.defineVariable("quickRace");
        }
        Actor content = builder.build(FileUtils.assets("screens/pauseoverlay.gdxui"));
        ((Actor)builder.getActor("resumeButton")).addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PauseOverlay.this.mRaceScreen.resumeRace();
            }
        });
        if (isQuickRace) {
            ((Actor)builder.getActor("restartButton")).addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    PauseOverlay.this.mRaceScreen.onRestartPressed();
                }
            });
        }
        ((Actor)builder.getActor("quitButton")).addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PauseOverlay.this.mRaceScreen.onQuitPressed();
            }
        });
        ((Actor)builder.getActor("settingsButton")).addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PauseOverlay.this.mRaceScreen.onSettingsPressed();
            }
        });
        return content;
    }
}

