/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.utils;

import com.agateau.translations.Translator;
import com.agateau.utils.log.NLog;
import java.util.Locale;

public class StringUtils {
    public static String formatRaceTime(float time) {
        int minutes = (int)(time / 60.0f);
        int seconds = (int)time % 60;
        int millis = (int)(time * 1000.0f) % 1000;
        return String.format(Locale.US, "%d:%02d.%03d", minutes, seconds, millis);
    }

    public static String formatRankInTable(int rank) {
        return StringUtils.format("%d.", rank);
    }

    public static String format(String fmt, Object ... args) {
        return String.format(Locale.getDefault(), fmt, args);
    }

    public static String formatRankInHud(int rank) {
        switch (rank) {
            case 1: {
                return Translator.tr("1st");
            }
            case 2: {
                return Translator.tr("2nd");
            }
            case 3: {
                return Translator.tr("3rd");
            }
            case 4: {
                return Translator.tr("4th");
            }
            case 5: {
                return Translator.tr("5th");
            }
            case 6: {
                return Translator.tr("6th");
            }
        }
        NLog.e("Unsupported rank %d", rank);
        return String.valueOf(rank);
    }

    public static String missingInputHandlerMessage() {
        return Translator.tr("Disconnected");
    }
}

