/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.menu.FocusIndicator;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItem;
import com.agateau.ui.menu.MenuItemGroup;
import com.agateau.utils.AgcMathUtils;
import com.agateau.utils.Assert;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;

public class TabMenuItem
extends Actor
implements MenuItem {
    private static final float HANDLE_SPEED = 5.0f;
    private final FocusIndicator mFocusIndicator;
    private final Menu mMenu;
    private final GlyphLayout mGlyphLayout = new GlyphLayout();
    private final Array<Page> mPages = new Array();
    private final Rectangle mFocusRectangle = new Rectangle();
    private final BitmapFont mFont;
    private final TabMenuItemStyle mStyle;
    private int mPreviousTab = -1;
    private int mCurrentTab = 0;
    private float mHandleAnimProgress = 0.0f;

    public TabMenuItem(Menu menu) {
        this.mMenu = menu;
        this.mFocusIndicator = new FocusIndicator(menu);
        this.mFont = menu.getSkin().get("default-font", BitmapFont.class);
        this.mStyle = menu.getSkin().get(TabMenuItemStyle.class);
        this.setTouchable(Touchable.enabled);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                float tabRight = ((TabMenuItem)TabMenuItem.this).mStyle.framePadding;
                for (int idx = 0; idx < ((TabMenuItem)TabMenuItem.this).mPages.size; ++idx) {
                    if (!(x < (tabRight += ((Page)((TabMenuItem)TabMenuItem.this).mPages.get((int)idx)).tabWidth))) continue;
                    TabMenuItem.this.setCurrentTab(idx);
                    return;
                }
            }
        });
    }

    public MenuItemGroup addPage(String name) {
        MenuItemGroup parentGroup = this.mMenu.findItemParentGroup(this);
        Assert.check(parentGroup != null, "TabMenuItem must have be added to a group before calling addPage()", new Object[0]);
        this.mGlyphLayout.setText(this.mFont, name);
        float tabWidth = this.mGlyphLayout.width + this.mStyle.tabPadding * 2.0f;
        MenuItemGroup group = new MenuItemGroup(this.mMenu);
        parentGroup.addItem(group);
        this.mPages.add(new Page(name, group, tabWidth));
        if (this.mPages.size > 1) {
            parentGroup.setItemVisible(group, false);
        }
        float width = 0.0f;
        for (Page page : this.mPages) {
            width += page.tabWidth;
        }
        this.setSize(width + this.mStyle.framePadding * 2.0f, this.mStyle.frame.getMinHeight());
        return group;
    }

    public void setCurrentPage(MenuItemGroup group) {
        for (int idx = 0; idx < this.mPages.size; ++idx) {
            if (this.mPages.get((int)idx).group != group) continue;
            this.setCurrentTab(idx);
        }
    }

    @Override
    public Actor getActor() {
        return this;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setFocused(boolean focused) {
        this.mFocusIndicator.setFocused(focused);
    }

    @Override
    public void trigger() {
    }

    @Override
    public boolean goUp() {
        return false;
    }

    @Override
    public boolean goDown() {
        return false;
    }

    @Override
    public void goLeft() {
        this.setCurrentTab(this.mCurrentTab - 1);
    }

    @Override
    public void goRight() {
        this.setCurrentTab(this.mCurrentTab + 1);
    }

    @Override
    public Rectangle getFocusRectangle() {
        this.mFocusRectangle.x = 0.0f;
        this.mFocusRectangle.y = 0.0f;
        this.mFocusRectangle.width = this.getWidth();
        this.mFocusRectangle.height = this.getHeight();
        float focusPadding = this.mMenu.getMenuStyle().focusPadding;
        AgcMathUtils.adjustRectangle(this.mFocusRectangle, -2.0f * focusPadding);
        return this.mFocusRectangle;
    }

    @Override
    public float getParentWidthRatio() {
        return 0.0f;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.mFocusIndicator.act(delta);
        if (this.mPreviousTab != this.mCurrentTab) {
            if (this.mPreviousTab == -1) {
                this.mPreviousTab = this.mCurrentTab;
            } else {
                this.mHandleAnimProgress += delta * 5.0f;
                if (this.mHandleAnimProgress > 1.0f) {
                    this.mHandleAnimProgress = 0.0f;
                    this.mPreviousTab = this.mCurrentTab;
                }
            }
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.mPages.size == 0) {
            return;
        }
        this.mFocusIndicator.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.drawFrame(batch);
        this.drawHandle(batch);
        this.drawText(batch);
    }

    private void drawFrame(Batch batch) {
        float distance = this.getDistanceToLeftEdge();
        this.drawFrameBorder(batch, this.mStyle.leftTabBorder, this.getX() - distance, distance);
        this.drawFrameBorder(batch, this.mStyle.rightTabBorder, this.getRight(), this.getStage().getWidth() - this.getRight());
        this.mStyle.frame.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private float getDistanceToLeftEdge() {
        float x = 0.0f;
        for (Actor actor = this; actor != null; actor = actor.getParent()) {
            x += actor.getX();
        }
        return x;
    }

    private void drawFrameBorder(Batch batch, Drawable drawable, float x, float width) {
        drawable.draw(batch, x, this.getY(), width, drawable.getMinHeight());
    }

    private float getTabX(int tab) {
        float x = 0.0f;
        for (int idx = 0; idx < tab; ++idx) {
            x += this.mPages.get((int)idx).tabWidth;
        }
        return x;
    }

    private void drawHandle(Batch batch) {
        float width;
        float x;
        float framePadding = this.mStyle.framePadding;
        if (this.mCurrentTab == this.mPreviousTab) {
            x = this.getTabX(this.mCurrentTab);
            width = this.mPages.get((int)this.mCurrentTab).tabWidth;
        } else {
            float srcX = this.getTabX(this.mPreviousTab);
            float dstX = this.getTabX(this.mCurrentTab);
            float srcWidth = this.mPages.get((int)this.mPreviousTab).tabWidth;
            float dstWidth = this.mPages.get((int)this.mCurrentTab).tabWidth;
            x = MathUtils.lerp(srcX, dstX, this.mHandleAnimProgress);
            width = MathUtils.lerp(srcWidth, dstWidth, this.mHandleAnimProgress);
        }
        this.mStyle.handle.draw(batch, this.getX() + framePadding + x, this.getY() + framePadding, width, this.getHeight() - 2.0f * framePadding);
    }

    private void drawText(Batch batch) {
        float x = this.mStyle.framePadding;
        float y = this.getY() + (this.mFont.getCapHeight() + this.getHeight()) / 2.0f;
        for (int idx = 0; idx < this.mPages.size; ++idx) {
            String name = this.mPages.get((int)idx).name;
            float tabWidth = this.mPages.get((int)idx).tabWidth;
            this.mFont.draw(batch, name, this.getX() + x, y, tabWidth, 1, false);
            x += tabWidth;
        }
    }

    private void setCurrentTab(int currentTab) {
        MenuItemGroup parentGroup = this.mMenu.findItemParentGroup(this);
        this.mCurrentTab = MathUtils.clamp(currentTab, 0, this.mPages.size - 1);
        for (int idx = 0; idx < this.mPages.size; ++idx) {
            MenuItemGroup page = this.mPages.get((int)idx).group;
            parentGroup.setItemVisible(page, idx == this.mCurrentTab);
        }
    }

    public static class TabMenuItemStyle {
        Drawable frame;
        float framePadding;
        float tabPadding;
        Drawable handle;
        Drawable leftTabBorder;
        Drawable rightTabBorder;
    }

    private static class Page {
        final String name;
        final MenuItemGroup group;
        final float tabWidth;

        private Page(String name, MenuItemGroup group, float tabWidth) {
            this.name = name;
            this.group = group;
            this.tabWidth = tabWidth;
        }
    }
}

