/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.bonus.Bonus;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.utils.ReflectionPool;

public class BonusPool<T extends Bonus>
extends ReflectionPool<T> {
    private final Assets mAssets;
    private final GameWorld mGameWorld;
    private final AudioManager mAudioManager;
    private float[] mCounts;

    public BonusPool(Class<T> type, Assets assets, GameWorld gameWorld, AudioManager audioManager) {
        super(type);
        this.mAssets = assets;
        this.mGameWorld = gameWorld;
        this.mAudioManager = audioManager;
    }

    public void setCounts(float[] counts) {
        this.mCounts = counts;
    }

    public float getCountForNormalizedRank(float normalizedRank) {
        return AgcMathUtils.arrayLerp(this.mCounts, normalizedRank);
    }

    public GameWorld getGameWorld() {
        return this.mGameWorld;
    }

    @Override
    protected T newObject() {
        Bonus object = (Bonus)super.newObject();
        object.init(this, this.mAssets, this.mGameWorld, this.mAudioManager);
        return (T)object;
    }
}

