/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.obstacles;

import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.TextureRegionProvider;
import com.agateau.pixelwheels.map.MapObjectWalker;
import com.agateau.pixelwheels.map.MapObjectWalkerFactory;
import com.agateau.pixelwheels.map.MapUtils;
import com.agateau.pixelwheels.obstacles.Obstacle;
import com.agateau.pixelwheels.obstacles.ObstacleDef;
import com.agateau.pixelwheels.utils.Box2DUtils;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.World;
import java.util.HashMap;

public class ObstacleCreator {
    private final HashMap<String, ObstacleDef> mObstacleDefs = new HashMap();
    private final HashMap<ObstacleDef, BodyDef> mBodyDefs = new HashMap();

    public void addObstacleDef(ObstacleDef obstacleDef) {
        this.mObstacleDefs.put(obstacleDef.id, obstacleDef);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = obstacleDef.dynamic ? BodyDef.BodyType.DynamicBody : BodyDef.BodyType.StaticBody;
        bodyDef.bullet = false;
        this.mBodyDefs.put(obstacleDef, bodyDef);
    }

    public void create(GameWorld gameWorld, TextureRegionProvider textureRegionProvider, MapObject mapObject) {
        String id = MapUtils.getObstacleId(mapObject);
        if (id == null) {
            ObstacleCreator.createBorder(gameWorld.getBox2DWorld(), mapObject);
            return;
        }
        ObstacleDef obstacleDef = this.mObstacleDefs.get(id);
        BodyDef bodyDef = this.mBodyDefs.get(obstacleDef);
        MapObjectWalker walker = MapObjectWalkerFactory.get(mapObject);
        TextureRegion obstacleRegion = obstacleDef.getImage(textureRegionProvider);
        walker.walk(obstacleRegion.getRegionWidth(), obstacleRegion.getRegionHeight(), (x, y, angle) -> {
            bodyDef.position.set(x, y).scl(0.05f);
            bodyDef.angle = angle;
            Obstacle obstacle = new Obstacle(gameWorld.getBox2DWorld(), textureRegionProvider, obstacleDef, bodyDef);
            gameWorld.addGameObject(obstacle);
        });
    }

    private static void createBorder(World world, MapObject mapObject) {
        Body body = Box2DUtils.createStaticBodyForMapObject(world, mapObject);
        Box2DUtils.setCollisionInfo(body, 1, 14);
        Obstacle.setStaticObstacleRestitution(body);
    }
}

