/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.screens.ConfigScreen;
import com.agateau.pixelwheels.screens.DifficultySelectorController;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.SelectGameModeScreen;
import com.agateau.pixelwheels.screens.SelectPlayerCountScreen;
import com.agateau.pixelwheels.screens.SupportScreen;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.agateau.utils.PlatformUtils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class MainMenuScreen
extends PwStageScreen {
    private final PwGame mGame;

    public MainMenuScreen(PwGame game) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.setupUi();
        new PwRefreshHelper(game, this.getStage()){

            @Override
            protected void refresh() {
                MainMenuScreen.this.mGame.showMainMenu();
            }
        };
    }

    private void setupUi() {
        boolean desktop = PlatformUtils.isDesktop();
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().ui.atlas, this.mGame.getAssets().ui.skin);
        DifficultySelectorController.registerFactory(builder, this.mGame.getConfig());
        if (desktop) {
            builder.defineVariable("desktop");
        }
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/mainmenu.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        if (desktop) {
            ((Actor)builder.getActor("onePlayerButton")).addListener(new MenuItemListener(){

                @Override
                public void triggered() {
                    MainMenuScreen.this.mGame.pushScreen(new SelectGameModeScreen(MainMenuScreen.this.mGame, 1));
                }
            });
            ((Actor)builder.getActor("multiPlayerButton")).addListener(new MenuItemListener(){

                @Override
                public void triggered() {
                    MainMenuScreen.this.mGame.pushScreen(new SelectPlayerCountScreen(MainMenuScreen.this.mGame));
                }
            });
        } else {
            ((Actor)builder.getActor("quickRaceButton")).addListener(new MenuItemListener(){

                @Override
                public void triggered() {
                    MainMenuScreen.this.mGame.showQuickRace(1);
                }
            });
            ((Actor)builder.getActor("championshipButton")).addListener(new MenuItemListener(){

                @Override
                public void triggered() {
                    MainMenuScreen.this.mGame.showChampionship(1);
                }
            });
        }
        ((Actor)builder.getActor("settingsButton")).addListener(new MenuItemListener(){

            @Override
            public void triggered() {
                MainMenuScreen.this.mGame.pushScreen(new ConfigScreen(MainMenuScreen.this.mGame, ConfigScreen.Origin.MENU));
            }
        });
        ((Actor)builder.getActor("supportButton")).addListener(new MenuItemListener(){

            @Override
            public void triggered() {
                MainMenuScreen.this.mGame.pushScreen(new SupportScreen(MainMenuScreen.this.mGame));
            }
        });
        if (desktop) {
            Menu menu = (Menu)builder.getActor("menu");
            menu.addBackButton().addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    Gdx.app.exit();
                }
            });
        }
        Label versionLabel = (Label)builder.getActor("version");
        versionLabel.setText(this.getShortenedVersion());
        versionLabel.pack();
    }

    private String getShortenedVersion() {
        return "1.0.0".replace("alpha.", "a").replace("beta.", "b");
    }

    @Override
    public void onBackPressed() {
        Gdx.app.exit();
    }
}

