/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.rewards.RewardManager;
import com.agateau.pixelwheels.screens.VehicleDrawer;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.ui.menu.GridMenuItem;
import com.agateau.ui.menu.Menu;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;

public class VehicleSelector
extends GridMenuItem<VehicleDef> {
    private Assets mAssets;
    private RewardManager mRewardManager;

    public VehicleSelector(Menu menu) {
        super(menu);
    }

    public void init(Assets assets, RewardManager rewardManager) {
        this.mAssets = assets;
        this.mRewardManager = rewardManager;
        this.setItemSize(90.0f, 90.0f);
        Renderer renderer = new Renderer();
        this.setItemRenderer(renderer);
        this.setItems(this.mAssets.vehicleDefs);
    }

    private class Renderer
    implements GridMenuItem.ItemRenderer<VehicleDef> {
        private final VehicleDrawer mVehicleDrawer;

        private Renderer() {
            this.mVehicleDrawer = new VehicleDrawer(VehicleSelector.this.mAssets);
        }

        @Override
        public Rectangle getItemRectangle(float width, float height, VehicleDef vehicleDef) {
            this.mVehicleDrawer.setVehicleDef(vehicleDef);
            this.mVehicleDrawer.setCenter(width / 2.0f, height / 2.0f);
            return this.mVehicleDrawer.getRectangle();
        }

        @Override
        public boolean isItemEnabled(VehicleDef vehicleDef) {
            return VehicleSelector.this.mRewardManager.isVehicleUnlocked(vehicleDef);
        }

        @Override
        public void render(Batch batch, float x, float y, float width, float height, VehicleDef vehicleDef) {
            float old = batch.getPackedColor();
            if (!this.isItemEnabled(vehicleDef)) {
                batch.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            }
            this.mVehicleDrawer.setVehicleDef(vehicleDef);
            this.mVehicleDrawer.setCenter(x + width / 2.0f, y + height / 2.0f);
            this.mVehicleDrawer.draw(batch);
            batch.setPackedColor(old);
        }
    }
}

