/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.translations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Messages {
    private final PluralExpression mPluralExpression;
    public final HashMap<String, String> plainEntries = new HashMap();
    public final HashMap<PluralId, String[]> pluralEntries = new HashMap();

    public Messages(PluralExpression expression) {
        this.mPluralExpression = expression;
    }

    public int plural(int n) {
        return this.mPluralExpression.eval(n);
    }

    public String getCharacters() {
        TreeSet<Character> set = new TreeSet<Character>();
        for (String text : this.plainEntries.values()) {
            Messages.addToSet(set, text);
        }
        Iterator<String> iterator = this.pluralEntries.values().iterator();
        while (iterator.hasNext()) {
            String[] texts;
            for (String text : texts = (String[])iterator.next()) {
                Messages.addToSet(set, text);
            }
        }
        StringBuilder builder = new StringBuilder(set.size());
        for (Character ch : set) {
            if (ch.charValue() == ' ') continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    private static void addToSet(SortedSet<Character> set, String text) {
        for (int idx = text.length() - 1; idx >= 0; --idx) {
            set.add(Character.valueOf(text.charAt(idx)));
        }
    }

    public static interface PluralExpression {
        public int eval(int var1);
    }

    public static class PluralId {
        public final String singular;
        public final String plural;

        public PluralId(String s, String p) {
            this.singular = s;
            this.plural = p;
        }

        public int hashCode() {
            return this.singular.hashCode() * this.plural.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PluralId)) {
                return false;
            }
            PluralId other = (PluralId)obj;
            return this.singular.equals(other.singular) && this.plural.equals(other.plural);
        }
    }
}

