/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.translations;

import com.agateau.translations.Messages;
import com.agateau.translations.PoParser;
import com.agateau.translations.PoParserException;
import com.agateau.translations.Translator;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import java.io.BufferedReader;

public class PoImplementation
implements Translator.Implementation {
    private final Messages mMessages;

    private PoImplementation(Messages messages) {
        this.mMessages = messages;
    }

    public static PoImplementation load(FileHandle handle) {
        Messages messages = PoImplementation.tryLoad(handle);
        if (messages == null) {
            return null;
        }
        return new PoImplementation(messages);
    }

    @Override
    public String trc(String src, String context) {
        if (this.mMessages == null) {
            return src;
        }
        String key = context == null ? src : PoParser.createIdWithContext(context, src);
        String txt = this.mMessages.plainEntries.get(key);
        return txt == null ? src : txt;
    }

    @Override
    public String trn(String singular, String plural, int n) {
        String txt = this.findPluralTranslation(singular, plural, n);
        if (txt == null) {
            txt = n == 1 ? singular : plural;
        }
        return txt.replace("%#", String.valueOf(n));
    }

    @Override
    public String getCharacters() {
        if (this.mMessages == null) {
            return "";
        }
        return this.mMessages.getCharacters();
    }

    private String findPluralTranslation(String singular, String plural, int n) {
        if (this.mMessages == null) {
            return null;
        }
        Messages.PluralId id = new Messages.PluralId(singular, plural);
        String[] lst = this.mMessages.pluralEntries.get(id);
        if (lst == null) {
            return null;
        }
        return lst[this.mMessages.plural(n)];
    }

    private static Messages tryLoad(FileHandle handle) {
        if (!handle.exists()) {
            return null;
        }
        BufferedReader stream = handle.reader(1024, "UTF-8");
        PoParser parser = new PoParser(stream);
        try {
            return parser.parse();
        }
        catch (PoParserException exc) {
            NLog.e("Failed to parse %s: %s", handle.name(), exc);
            return null;
        }
    }
}

