/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameobject;

import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.gameobject.AudioClipper;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class AnimationObject
extends GameObjectAdapter
implements Pool.Poolable,
Disposable {
    private static final ReflectionPool<AnimationObject> sPool = new ReflectionPool<AnimationObject>(AnimationObject.class);
    private float mTime;
    private Animation<TextureRegion> mAnimation;
    private float mAnimationRadius;
    private float mPosX;
    private float mPosY;
    private Sound mSound;
    private AudioManager mAudioManager;

    @Override
    public void reset() {
    }

    @Override
    public void dispose() {
        sPool.free(this);
    }

    @Override
    public void act(float delta) {
        this.mTime += delta;
        if (this.mTime < 0.0f) {
            return;
        }
        if (this.mAnimation.isAnimationFinished(this.mTime)) {
            this.setFinished(true);
        }
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        if (this.mTime < 0.0f) {
            return;
        }
        if (zLevel != ZLevel.FLYING_LOW) {
            return;
        }
        TextureRegion region = this.mAnimation.getKeyFrame(this.mTime);
        if (!AgcMathUtils.rectangleContains(viewBounds, this.getPosition(), this.mAnimationRadius)) {
            return;
        }
        float w = 0.05f * (float)region.getRegionWidth();
        float h = 0.05f * (float)region.getRegionHeight();
        batch.draw(region, this.mPosX - w / 2.0f, this.mPosY - h / 2.0f, w, h);
    }

    @Override
    public void audioRender(AudioClipper clipper) {
        if (this.mSound != null) {
            this.mAudioManager.play(this.mSound, clipper.clip(this));
            this.mSound = null;
        }
    }

    @Override
    public float getX() {
        return this.mPosX;
    }

    @Override
    public float getY() {
        return this.mPosY;
    }

    public void initAudio(AudioManager audioManager, Sound sound) {
        this.mAudioManager = audioManager;
        this.mSound = sound;
    }

    public static AnimationObject create(Animation<TextureRegion> animation, float posX, float posY) {
        return AnimationObject.create(animation, posX, posY, 0.0f);
    }

    public static AnimationObject create(Animation<TextureRegion> animation, float posX, float posY, float delay) {
        AnimationObject obj = (AnimationObject)sPool.obtain();
        obj.mTime = -delay;
        obj.mAnimation = animation;
        obj.mPosX = posX;
        obj.mPosY = posY;
        obj.mSound = null;
        obj.mAnimationRadius = 0.0f;
        for (TextureRegion region : obj.mAnimation.getKeyFrames()) {
            float radius = 0.05f * DrawUtils.getTextureRegionRadius(region);
            obj.mAnimationRadius = Math.max(obj.mAnimationRadius, radius);
        }
        obj.setFinished(false);
        return obj;
    }
}

