/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.obstacles;

import com.agateau.pixelwheels.TextureRegionProvider;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Shape2D;

public class ObstacleDef {
    public final String id;
    public float density;
    public boolean dynamic;
    public Shape2D shape;

    ObstacleDef(String id) {
        this.id = id;
    }

    ObstacleDef(String id, float density) {
        this.id = id;
        this.density = density;
    }

    void createCircleShape(TextureRegionProvider textureRegionProvider) {
        this.shape = new Circle(0.0f, 0.0f, (float)this.getImage(textureRegionProvider).getRegionWidth() / 2.0f);
    }

    void createRectangleShape(TextureRegionProvider textureRegionProvider) {
        TextureRegion region = this.getImage(textureRegionProvider);
        float width = region.getRegionWidth();
        float height = region.getRegionHeight();
        this.shape = new Rectangle(-width / 2.0f, -height / 2.0f, width, height);
    }

    public static ObstacleDef createCircle(TextureRegionProvider textureRegionProvider, String id, float density) {
        ObstacleDef def = new ObstacleDef(id, density);
        def.createCircleShape(textureRegionProvider);
        return def;
    }

    public static ObstacleDef createRectangle(TextureRegionProvider textureRegionProvider, String id, float density) {
        ObstacleDef def = new ObstacleDef(id, density);
        def.createRectangleShape(textureRegionProvider);
        return def;
    }

    public TextureRegion getImage(TextureRegionProvider provider) {
        return provider.findRegion("obstacle-" + this.id);
    }
}

