/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gamesetup.ChampionshipMaestro;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.racer.LapPositionComponent;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racescreen.Overlay;
import com.agateau.pixelwheels.racescreen.RaceScreen;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.pixelwheels.utils.UiUtils;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.translations.Translator;
import com.agateau.ui.AnimatedImage;
import com.agateau.ui.TableRowCreator;
import com.agateau.ui.animscript.AnimScript;
import com.agateau.ui.animscript.AnimScriptLoader;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class FinishedOverlay
extends Overlay {
    private static final int RANK_CHANGE_COLUMN_SIZE = 16;
    private static final float POINTS_INCREASE_SOUND_VOLUME = 1.0f;
    private static final Comparator<Racer> sRacerComparator = (racer1, racer2) -> {
        GameInfo.Entrant entrant1 = racer1.getEntrant();
        GameInfo.Entrant entrant2 = racer2.getEntrant();
        int deltaPoints = entrant2.getPoints() - entrant1.getPoints();
        if (deltaPoints != 0) {
            return deltaPoints;
        }
        return Float.compare(entrant1.getRaceTime(), entrant2.getRaceTime());
    };
    private final PwGame mGame;
    private final RaceScreen mRaceScreen;
    private final Array<Racer> mRacers;
    private final Array<Animation<TextureRegion>> mRankChangeAnimations = new Array();
    private final List<PageCreator> mPageCreators = new LinkedList<PageCreator>();
    private float mFirstPointsIncreaseInterval = 1.0f;
    private float mPointsIncreaseInterval = 0.3f;
    private int mBestIndicatorWidth = 0;
    private float mBestIndicatorMargin = 0.0f;
    private int mColumnSpacing = 0;
    private final TableRowCreator mQuickRaceRowCreator = new TableRowCreator(RaceColumn.values().length - 1){

        @Override
        protected Cell<Label> createCell(Table table, int columnIdx, String value, String style) {
            Cell<Label> cell = table.add(value, style);
            RaceColumn column = RaceColumn.values()[columnIdx];
            switch (column) {
                case RACER: {
                    cell.left().expandX();
                    break;
                }
                case BEST_LAP_TIME: 
                case TOTAL_TIME: {
                    if (!style.equals("tableHeaderRow")) {
                        cell.padLeft((float)FinishedOverlay.this.mBestIndicatorWidth + FinishedOverlay.this.mBestIndicatorMargin);
                    }
                    cell.right();
                    break;
                }
                default: {
                    cell.right();
                }
            }
            return cell;
        }
    };
    private final TableRowCreator mChampionshipRaceRowCreator = new TableRowCreator(RaceColumn.values().length){

        @Override
        protected Cell<Label> createCell(Table table, int columnIdx, String value, String style) {
            Cell<Label> cell = table.add(value, style);
            RaceColumn column = RaceColumn.values()[columnIdx];
            switch (column) {
                case RACER: {
                    cell.left().expandX();
                    break;
                }
                case BEST_LAP_TIME: 
                case TOTAL_TIME: {
                    if (!style.equals("tableHeaderRow")) {
                        cell.padLeft((float)FinishedOverlay.this.mBestIndicatorWidth + FinishedOverlay.this.mBestIndicatorMargin);
                    }
                    cell.right();
                    break;
                }
                default: {
                    cell.right();
                }
            }
            return cell;
        }
    };
    private final TableRowCreator mChampionshipTotalRowCreator = new TableRowCreator(ChampionshipTotalColumn.values().length){

        @Override
        protected Cell createCell(Table table, int column, String value, String style) {
            Cell<Widget> cell;
            if (column == ChampionshipTotalColumn.RANK_CHANGE.ordinal()) {
                cell = table.add(new AnimatedImage());
                cell.size(16.0f);
            } else {
                cell = table.add(value, style);
            }
            if (column == ChampionshipTotalColumn.RACER.ordinal()) {
                cell.left().expandX();
            } else {
                cell.right();
            }
            return cell;
        }
    };
    private final Array<PointsAnimInfo> mPointsAnimInfos = new Array();
    private final Array<RecordAnimInfo> mRecordAnimInfos = new Array();
    private Sound mPointsIncreaseSound;
    private final Timer.Task mIncreasePointsTask = new Timer.Task(){

        @Override
        public void run() {
            boolean done = true;
            for (PointsAnimInfo info : FinishedOverlay.this.mPointsAnimInfos) {
                if (info.delta == 0) continue;
                ++info.points;
                --info.delta;
                FinishedOverlay.this.mGame.getAudioManager().play(FinishedOverlay.this.mPointsIncreaseSound, 1.0f);
                if (info.delta <= 0) continue;
                done = false;
            }
            if (!done) {
                FinishedOverlay.this.schedulePointsIncrease(FinishedOverlay.this.mPointsIncreaseInterval);
            }
            FinishedOverlay.this.updatePointsLabels();
        }
    };
    private final Vector2 mTmp = new Vector2();

    public FinishedOverlay(PwGame game, RaceScreen raceScreen, Array<Racer> racers) {
        super(game.getAssets().dot);
        this.mGame = game;
        this.mRaceScreen = raceScreen;
        this.mRacers = racers;
        new PwRefreshHelper(this.mGame, this){

            @Override
            protected void refresh() {
                FinishedOverlay.this.setupUi();
            }
        };
        this.setupUi();
    }

    private void setupUi() {
        this.mPointsIncreaseSound = this.mGame.getAssets().soundAtlas.get("points-increase");
        this.mBestIndicatorWidth = this.mGame.getAssets().ui.atlas.findRegion("best-1").getRegionWidth();
        this.fillPageCreators();
        this.showNextPage();
    }

    private void fillPageCreators() {
        this.mPageCreators.clear();
        if (this.isChampionship()) {
            this.mPageCreators.add(() -> this.createTablePage(TableType.CHAMPIONSHIP_RACE));
            this.mPageCreators.add(() -> this.createTablePage(TableType.CHAMPIONSHIP_TOTAL));
        } else {
            this.mPageCreators.add(() -> this.createTablePage(TableType.QUICK_RACE));
        }
    }

    private void showNextPage() {
        this.mIncreasePointsTask.cancel();
        PageCreator creator = this.mPageCreators.remove(0);
        this.setContent(creator.createPage());
    }

    private Actor createTablePage(TableType tableType) {
        boolean showCongratsCar;
        final UiBuilder builder = new UiBuilder(this.mGame.getAssets().ui.atlas, this.mGame.getAssets().ui.skin);
        if (!this.isChampionship()) {
            builder.defineVariable("quickRace");
        }
        boolean bl = showCongratsCar = tableType != TableType.CHAMPIONSHIP_TOTAL && this.shouldShowCongratsCar();
        if (showCongratsCar) {
            builder.defineVariable("showCongratsCar");
        }
        HashMap<Racer, Integer> oldRankMap = null;
        if (tableType == TableType.CHAMPIONSHIP_TOTAL) {
            this.mRacers.sort(sRacerComparator);
            ChampionshipMaestro maestro = (ChampionshipMaestro)this.mGame.getMaestro();
            if (!maestro.isFirstTrack()) {
                oldRankMap = this.createOldRankMap();
            }
        }
        final Actor content = builder.build(FileUtils.assets("screens/finishedoverlay.gdxui"));
        this.mFirstPointsIncreaseInterval = builder.getFloatConfigValue("firstPointsIncreaseInterval");
        this.mPointsIncreaseInterval = builder.getFloatConfigValue("pointsIncreaseInterval");
        this.mBestIndicatorMargin = builder.getFloatConfigValue("bestIndicatorMargin");
        this.mColumnSpacing = builder.getIntConfigValue("columnSpacing");
        this.loadRankChangeAnimations(builder);
        Table table = (Table)builder.getActor("scrollableTable");
        Label titleLabel = (Label)builder.getActor("titleLabel");
        titleLabel.setText(tableType == TableType.CHAMPIONSHIP_TOTAL ? Translator.tr("Championship Rankings") : Translator.tr("Race Results"));
        titleLabel.pack();
        this.fillMenu(builder);
        this.fillTable(table, tableType, oldRankMap);
        if (showCongratsCar) {
            Label label = (Label)builder.getActor("congratsCarLabel");
            label.setText(this.pickCongratsCarLabelText());
            label.setHeight(label.getPrefHeight());
        }
        if (!this.mRecordAnimInfos.isEmpty()) {
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    FinishedOverlay.this.createRecordAnimations(builder, (Group)content);
                }
            }, 0.5f);
        }
        return content;
    }

    private String pickCongratsCarLabelText() {
        String[] messages = new String[]{Translator.tr("Congratulations, great race!"), Translator.tr("You've got some serious driving skills!"), Translator.tr("You're a champ!"), Translator.tr("Congrats for this performance!"), Translator.tr("Impressive!")};
        int idx = MathUtils.random(messages.length - 1);
        return messages[idx];
    }

    private void loadRankChangeAnimations(UiBuilder builder) {
        float speed = builder.getFloatConfigValue("rankChangeAnimationSpeed");
        this.mRankChangeAnimations.clear();
        for (String name : new String[]{"rank-down", "rank-same", "rank-up"}) {
            Array<TextureAtlas.AtlasRegion> regions = this.mGame.getAssets().ui.atlas.findRegions(name);
            Animation<TextureAtlas.AtlasRegion> animation = new Animation<TextureAtlas.AtlasRegion>(speed, regions);
            this.mRankChangeAnimations.add(animation);
        }
    }

    private static int getOldPointsForRacer(Racer racer) {
        GameInfo.Entrant entrant = racer.getEntrant();
        return entrant.getPoints() - entrant.getLastRacePoints();
    }

    private HashMap<Racer, Integer> createOldRankMap() {
        HashMap<Racer, Integer> oldRank = new HashMap<Racer, Integer>();
        Array<Racer> racers = new Array<Racer>(this.mRacers);
        racers.sort((racer1, racer2) -> -Integer.compare(FinishedOverlay.getOldPointsForRacer(racer1), FinishedOverlay.getOldPointsForRacer(racer2)));
        for (int idx = 0; idx < racers.size; ++idx) {
            oldRank.put(racers.get(idx), idx);
        }
        return oldRank;
    }

    private void fillMenu(UiBuilder builder) {
        if (!this.isChampionship()) {
            ((Actor)builder.getActor("restartButton")).addListener(new MenuItemListener(){

                @Override
                public void triggered() {
                    FinishedOverlay.this.mRaceScreen.getListener().onRestartPressed();
                }
            });
        }
        ((Actor)builder.getActor("continueButton")).addListener(new MenuItemListener(){

            @Override
            public void triggered() {
                if (FinishedOverlay.this.mPageCreators.isEmpty()) {
                    FinishedOverlay.this.mRaceScreen.getListener().onNextTrackPressed();
                } else {
                    FinishedOverlay.this.showNextPage();
                }
            }
        });
    }

    private TableRowCreator getRowCreatorForTable(TableType tableType) {
        switch (tableType) {
            case QUICK_RACE: {
                return this.mQuickRaceRowCreator;
            }
            case CHAMPIONSHIP_RACE: {
                return this.mChampionshipRaceRowCreator;
            }
            case CHAMPIONSHIP_TOTAL: {
                return this.mChampionshipTotalRowCreator;
            }
        }
        throw new AssertionError();
    }

    private void fillTable(Table table, TableType tableType, HashMap<Racer, Integer> oldRankMap) {
        this.mPointsAnimInfos.clear();
        this.mRecordAnimInfos.clear();
        TableRowCreator rowCreator = this.getRowCreatorForTable(tableType);
        rowCreator.setTable(table);
        rowCreator.setSpacing(this.mColumnSpacing);
        switch (tableType) {
            case QUICK_RACE: {
                rowCreator.addHeaderRow(Translator.tr("#"), Translator.tr("Racer"), Translator.tr("Best lap"), Translator.tr("Total time"));
                break;
            }
            case CHAMPIONSHIP_RACE: {
                rowCreator.addHeaderRow(Translator.tr("#"), Translator.tr("Racer"), Translator.tr("Best lap"), Translator.tr("Total time"), Translator.tr("Points"));
                break;
            }
            case CHAMPIONSHIP_TOTAL: {
                rowCreator.addHeaderRow(Translator.tr("#"), Translator.tr("Racer"), "", Translator.tr("Race time"), Translator.tr("Points"));
            }
        }
        for (int idx = 0; idx < this.mRacers.size; ++idx) {
            RecordAnimInfo info;
            Cell cell;
            Racer racer = this.mRacers.get(idx);
            GameInfo.Entrant entrant = racer.getEntrant();
            rowCreator.setRowStyle(UiUtils.getEntrantRowStyle(entrant));
            switch (tableType) {
                case QUICK_RACE: 
                case CHAMPIONSHIP_RACE: {
                    this.createRaceRow(tableType, rowCreator, idx, racer);
                    break;
                }
                case CHAMPIONSHIP_TOTAL: {
                    this.createChampionshipTotalRow(oldRankMap, idx, racer);
                }
            }
            if (tableType != TableType.QUICK_RACE) {
                Cell pointsCell = rowCreator.getCreatedRowCell(-1);
                PointsAnimInfo info2 = new PointsAnimInfo();
                info2.label = (Label)pointsCell.getActor();
                if (tableType == TableType.CHAMPIONSHIP_RACE) {
                    info2.delta = entrant.getLastRacePoints();
                    info2.points = entrant.getPoints() - info2.delta;
                } else {
                    info2.points = entrant.getPoints();
                }
                this.mPointsAnimInfos.add(info2);
            }
            if (tableType == TableType.CHAMPIONSHIP_TOTAL || !racer.getRecordRanks().brokeRecord()) continue;
            Racer.RecordRanks ranks = racer.getRecordRanks();
            if (ranks.lapRecordRank >= 0) {
                cell = rowCreator.getCreatedRowCell(RaceColumn.BEST_LAP_TIME.ordinal());
                info = new RecordAnimInfo(cell, ranks.lapRecordRank);
                this.mRecordAnimInfos.add(info);
            }
            if (ranks.totalRecordRank < 0) continue;
            cell = rowCreator.getCreatedRowCell(RaceColumn.TOTAL_TIME.ordinal());
            info = new RecordAnimInfo(cell, ranks.totalRecordRank);
            this.mRecordAnimInfos.add(info);
        }
        if (tableType != TableType.QUICK_RACE) {
            this.updatePointsLabels();
            if (tableType == TableType.CHAMPIONSHIP_RACE) {
                this.schedulePointsIncrease(this.mFirstPointsIncreaseInterval);
            }
        }
    }

    private void createRaceRow(TableType tableType, TableRowCreator rowCreator, int idx, Racer racer) {
        String totalTime;
        String bestLapTime;
        String name = this.getRacerName(racer);
        String rank = StringUtils.formatRankInTable(idx + 1);
        LapPositionComponent lapPositionComponent = racer.getLapPositionComponent();
        if (lapPositionComponent.getStatus() == LapPositionComponent.Status.DID_NOT_START) {
            bestLapTime = "-";
            totalTime = "-";
        } else {
            bestLapTime = StringUtils.formatRaceTime(lapPositionComponent.getBestLapTime());
            totalTime = StringUtils.formatRaceTime(lapPositionComponent.getTotalTime());
        }
        if (tableType == TableType.QUICK_RACE) {
            rowCreator.addRow(rank, name, bestLapTime, totalTime);
        } else {
            rowCreator.addRow(rank, name, bestLapTime, totalTime, "");
        }
    }

    private void createChampionshipTotalRow(HashMap<Racer, Integer> oldRankMap, int idx, Racer racer) {
        String rank = StringUtils.formatRankInTable(idx + 1);
        String name = this.getRacerName(racer);
        String totalTime = StringUtils.formatRaceTime(racer.getEntrant().getRaceTime());
        this.mChampionshipTotalRowCreator.addRow(rank, name, null, totalTime, "");
        if (oldRankMap == null) {
            return;
        }
        int oldIdx = oldRankMap.get(racer);
        Animation<TextureRegion> animation = this.mRankChangeAnimations.get((int)Math.signum(oldIdx - idx) + 1);
        Cell rankChangeCell = this.mChampionshipTotalRowCreator.getCreatedRowCell(ChampionshipTotalColumn.RANK_CHANGE.ordinal());
        ((AnimatedImage)rankChangeCell.getActor()).setAnimation(animation);
    }

    private void schedulePointsIncrease(float interval) {
        Timer.schedule(this.mIncreasePointsTask, interval);
    }

    private void updatePointsLabels() {
        for (PointsAnimInfo info : this.mPointsAnimInfos) {
            String points = info.delta == 0 ? String.valueOf(info.points) : StringUtils.format("+%d %d", info.delta, info.points);
            info.label.setText(points);
        }
    }

    private boolean isChampionship() {
        return this.mRaceScreen.getGameType() == GameInfo.GameType.CHAMPIONSHIP;
    }

    private boolean shouldShowCongratsCar() {
        for (int idx = 0; idx < Math.min(3, this.mRacers.size); ++idx) {
            Racer racer = this.mRacers.get(idx);
            if (!racer.getRecordRanks().brokeRecord()) continue;
            return true;
        }
        return false;
    }

    private String getRacerName(Racer racer) {
        VehicleDef vehicleDef = this.mGame.getAssets().findVehicleDefById(racer.getVehicle().getId());
        return vehicleDef.getName();
    }

    private void createRecordAnimations(UiBuilder builder, Group root) {
        AnimScript script;
        try {
            script = builder.getAnimScriptConfigValue("bestIndicatorAnimation");
        }
        catch (AnimScriptLoader.SyntaxException e) {
            NLog.e("Error loading animscript: " + e, new Object[0]);
            return;
        }
        for (RecordAnimInfo info : this.mRecordAnimInfos) {
            TextureAtlas.AtlasRegion region = this.mGame.getAssets().ui.atlas.findRegion("best-" + (info.rank + 1));
            Image image = new Image(region);
            image.setOrigin(1);
            image.pack();
            root.addActor(image);
            this.mTmp.set(-image.getWidth() - this.mBestIndicatorMargin, (info.label.getHeight() - image.getHeight()) / 2.0f);
            Vector2 pos = info.label.localToAscendantCoordinates(root, this.mTmp);
            Action action = script.createAction();
            image.setPosition(pos.x, pos.y);
            image.addAction(action);
            action.act(0.0f);
        }
    }

    static enum RaceColumn {
        RANK,
        RACER,
        BEST_LAP_TIME,
        TOTAL_TIME,
        POINTS;

    }

    static enum ChampionshipTotalColumn {
        RANK,
        RACER,
        RANK_CHANGE,
        TOTAL_TIME,
        POINTS;

    }

    static interface PageCreator {
        public Actor createPage();
    }

    private static enum TableType {
        QUICK_RACE,
        CHAMPIONSHIP_RACE,
        CHAMPIONSHIP_TOTAL;

    }

    private static class PointsAnimInfo {
        Label label;
        int points;
        int delta = 0;

        private PointsAnimInfo() {
        }
    }

    private static class RecordAnimInfo {
        final Label label;
        final int rank;

        private RecordAnimInfo(Cell<Label> labelCell, int rank) {
            this.label = labelCell.getActor();
            this.rank = rank;
        }
    }
}

