/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.pixelwheels.utils.DrawUtils;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class HudButton
extends Widget {
    private static final float BUTTON_OPACITY = 0.5f;
    private static final float DISABLED_BUTTON_OPACITY = 0.2f;
    private final TextureRegion[] mRegions = new TextureRegion[2];
    private final Hud mHud;
    private final ClickListener mClickListener;
    private boolean mEnabled = true;

    public HudButton(Assets assets, Hud hud, String name) {
        this.mHud = hud;
        this.mRegions[0] = assets.findRegion("hud-" + name);
        this.mRegions[1] = assets.findRegion("hud-" + name + "-down");
        this.setTouchable(Touchable.enabled);
        this.mClickListener = new ClickListener();
        this.addListener(this.mClickListener);
    }

    public boolean isPressed() {
        return this.mClickListener.isVisualPressed();
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public Hud getHud() {
        return this.mHud;
    }

    @Override
    public void draw(Batch batch, float alpha) {
        float oldA = DrawUtils.multiplyBatchAlphaBy(batch, this.mEnabled ? 0.5f : 0.2f);
        batch.draw(this.mRegions[this.isPressed() ? 1 : 0], (float)MathUtils.round(this.getX()), (float)MathUtils.round(this.getY()), this.getWidth(), this.getHeight());
        DrawUtils.setBatchAlpha(batch, oldA);
    }

    @Override
    public void validate() {
        this.setSize((float)this.mRegions[0].getRegionWidth() * this.mHud.getZoom(), (float)this.mRegions[0].getRegionHeight() * this.mHud.getZoom());
    }
}

