/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.debug.DebugStringMap;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.pixelwheels.racescreen.HudButton;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorGroup;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.PerformanceCounter;
import com.badlogic.gdx.utils.PerformanceCounters;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Map;

public class RacerHudController {
    private final Assets mAssets;
    private final GameWorld mGameWorld;
    private final Hud mHud;
    private final Racer mRacer;
    private PerformanceCounters mPerformanceCounters = null;
    private Label mRankLabel;
    private Label mLapLabel;
    private VerticalGroup mDebugGroup = null;
    private Label mDebugLabel = null;
    private final StringBuilder mStringBuilder = new StringBuilder();
    private final String[] mRankStrings;
    private static final StringBuilder sDebugSB = new StringBuilder();

    public RacerHudController(Assets assets, GameWorld gameWorld, Hud hud, Racer racer) {
        this.mRankStrings = new String[GamePlay.instance.racerCount];
        this.mAssets = assets;
        this.mGameWorld = gameWorld;
        this.mHud = hud;
        this.mRacer = racer;
        AnchorGroup root = hud.getRoot();
        for (int idx = 0; idx < this.mRankStrings.length; ++idx) {
            this.mRankStrings[idx] = StringUtils.formatRankInHud(idx + 1);
        }
        this.createPlayerLabels(root);
    }

    public Hud getHud() {
        return this.mHud;
    }

    private void createPlayerLabels(AnchorGroup root) {
        Skin skin = this.mAssets.ui.skin;
        TextureRegion lapIconRegion = this.mAssets.findRegion("lap-icon");
        boolean singlePlayer = this.mGameWorld.getPlayerRacers().size == 1;
        this.mRankLabel = new Label("", skin, singlePlayer ? "hudRank" : "smallHudRank");
        this.mRankLabel.setAlignment(16);
        this.mLapLabel = new Label("", skin, singlePlayer ? "hud" : "smallHud");
        this.mLapLabel.setAlignment(16);
        Image lapIconImage = new Image(lapIconRegion);
        lapIconImage.pack();
        root.addPositionRule(this.mRankLabel, Anchor.TOP_RIGHT, root, Anchor.TOP_RIGHT, -5.0f, 0.0f);
        root.addPositionRule(this.mLapLabel, Anchor.TOP_RIGHT, this.mRankLabel, Anchor.BOTTOM_RIGHT, 0.0f, 10.0f);
        root.addPositionRule(lapIconImage, Anchor.CENTER_RIGHT, this.mLapLabel, Anchor.CENTER_LEFT, -8.0f, 0.0f);
    }

    public void initDebugHud(PerformanceCounters performanceCounters) {
        this.mPerformanceCounters = performanceCounters;
        this.mDebugGroup = new VerticalGroup();
        this.mDebugLabel = new Label("D", this.mAssets.ui.skin, "tiny");
        AnchorGroup root = this.mHud.getRoot();
        root.addPositionRule(this.mDebugGroup, Anchor.CENTER_LEFT, root, Anchor.CENTER_LEFT, 40.0f, 0.0f);
        this.mDebugGroup.addActor(this.mDebugLabel);
        this.mDebugGroup.pack();
    }

    public void addDebugActor(Actor actor) {
        this.mDebugGroup.addActor(actor);
        this.mDebugGroup.pack();
    }

    public void createPauseButton(ClickListener clickListener) {
        HudButton button = new HudButton(this.mAssets, this.mHud, "pause");
        button.addListener(clickListener);
        this.mHud.addPauseButton(button);
    }

    public void act(float delta) {
        this.updateLabels();
        if (this.mDebugLabel != null) {
            this.updateDebugLabel();
        }
    }

    private void updateLabels() {
        int lapCount = Math.max(this.mRacer.getLapPositionComponent().getLapCount(), 1);
        int totalLapCount = this.mGameWorld.getTrack().getTotalLapCount();
        int rank = this.mGameWorld.getRacerRank(this.mRacer);
        this.mRankLabel.setText(this.mRankStrings[rank - 1]);
        this.mRankLabel.pack();
        this.mStringBuilder.setLength(0);
        this.mStringBuilder.append(lapCount).append('/').append(totalLapCount);
        this.mLapLabel.setText(this.mStringBuilder);
        this.mLapLabel.pack();
    }

    private void updateDebugLabel() {
        sDebugSB.setLength(0);
        sDebugSB.append("objCount: ").append(this.mGameWorld.getActiveGameObjects().size).append('\n');
        sDebugSB.append("FPS: ").append(Gdx.graphics.getFramesPerSecond()).append('\n');
        for (PerformanceCounter counter : this.mPerformanceCounters.counters) {
            sDebugSB.append(counter.name).append(": ").append(String.valueOf((int)(counter.time.value * 1000.0f))).append(" | ").append(String.valueOf((int)(counter.load.value * 100.0f))).append("%\n");
        }
        for (Map.Entry<String, String> entry : DebugStringMap.getMap().entrySet()) {
            sDebugSB.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        this.mDebugLabel.setText(sDebugSB);
    }
}

