/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen.debug;

import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.bonus.Mine;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.racescreen.GameRenderer;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;

public class MineDropper
extends GameObjectAdapter {
    private final Vector2 mCoord = new Vector2();
    private final PwGame mGame;
    private final GameWorld mGameWorld;
    private final GameRenderer mGameRenderer;
    private boolean mActive = false;

    public MineDropper(PwGame game, GameWorld gameWorld, GameRenderer gameRenderer) {
        this.mGame = game;
        this.mGameWorld = gameWorld;
        this.mGameRenderer = gameRenderer;
    }

    public Button createDebugButton() {
        final TextButton button = new TextButton("Mine dropper", this.mGame.getAssets().ui.skin, "tiny");
        button.setProgrammaticChangeEvents(false);
        button.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MineDropper.this.mActive = button.isChecked();
            }
        });
        return button;
    }

    @Override
    public void act(float delta) {
        if (!this.mActive) {
            return;
        }
        if (Gdx.input.justTouched()) {
            this.mCoord.set(Gdx.input.getX(), Gdx.input.getY());
            this.mGameRenderer.mapFromScreen(this.mCoord);
            Mine.createDroppedMine(this.mGameWorld, this.mGame.getAssets(), this.mGame.getAudioManager(), this.mCoord);
        }
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
    }

    @Override
    public float getX() {
        return 0.0f;
    }

    @Override
    public float getY() {
        return 0.0f;
    }
}

