/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.translations.Translator;
import com.agateau.ui.CreditsScrollPane;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.XmlReader;

class CreditsScreen
extends PwStageScreen {
    private final PwGame mGame;

    CreditsScreen(PwGame game) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                CreditsScreen.this.mGame.replaceScreen(new CreditsScreen(CreditsScreen.this.mGame));
            }
        };
    }

    private void setupUi() {
        Skin skin = this.mGame.getAssets().ui.skin;
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().atlas, skin);
        builder.registerActorFactory("CreditsScrollPane", (uiBuilder, element) -> {
            CreditsScrollPane pane = new CreditsScrollPane();
            Actor child = uiBuilder.buildChildren(element, null);
            if (child != null) {
                ((ScrollPane)pane).setActor(child);
            }
            return pane;
        });
        AnchorGroup root = (AnchorGroup)builder.build(this.loadCreditsXml());
        root.setFillParent(true);
        this.getStage().addActor(root);
        CreditsScrollPane pane = (CreditsScrollPane)builder.getActor("creditsScrollPane");
        float stageHeight = this.getStage().getHeight();
        VerticalGroup group = pane.getGroup();
        group.addActorAt(0, this.createSpacer(stageHeight));
        this.addSpacer(group, stageHeight * 2.0f / 3.0f);
        group.addActor(new Label((CharSequence)Translator.tr("Thank you for playing!"), this.mGame.getAssets().ui.skin));
        this.addSpacer(group, stageHeight / 2.0f);
        Menu menu = (Menu)builder.getActor("menu");
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                CreditsScreen.this.onBackPressed();
            }
        });
        for (Actor actor : group.getChildren()) {
            if (!(actor instanceof Label)) continue;
            Label label = (Label)actor;
            label.setAlignment(1);
            label.setWrap(true);
            label.setWidth(group.getWidth());
            label.setHeight(label.getPrefHeight());
        }
    }

    private XmlReader.Element loadCreditsXml() {
        FileHandle handle = FileUtils.assets("screens/credits.gdxui");
        XmlReader.Element root = FileUtils.parseXml(handle);
        for (XmlReader.Element element : root.getChildrenByNameRecursively("Label")) {
            if (!element.getAttribute("style", "").equals("creditsSection")) continue;
            element.setText(String.format("-= %s =-", Translator.tr(element.getText())));
        }
        return root;
    }

    private void addSpacer(VerticalGroup group, float height) {
        group.addActor(this.createSpacer(height));
    }

    private Actor createSpacer(float height) {
        Actor spacer = new Actor();
        spacer.setSize(1.0f, height);
        return spacer;
    }

    @Override
    public void onBackPressed() {
        this.mGame.popScreen();
    }
}

