/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.rewards.RewardManager;
import com.agateau.ui.TextureRegionItemRendererAdapter;
import com.agateau.ui.menu.GridMenuItem;
import com.agateau.ui.menu.Menu;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class TrackSelector
extends GridMenuItem<Track> {
    private Assets mAssets;
    private RewardManager mRewardManager;

    public TrackSelector(Menu menu) {
        super(menu);
    }

    public void init(Assets assets, RewardManager rewardManager, Championship championship) {
        this.mAssets = assets;
        this.mRewardManager = rewardManager;
        this.setItemSize(160.0f, 160.0f);
        this.setItemRenderer(new Renderer());
        this.setCurrentChampionship(championship);
    }

    public void setCurrentChampionship(Championship championship) {
        this.setItems(championship.getTracks());
    }

    private class Renderer
    extends TextureRegionItemRendererAdapter<Track> {
        private Renderer() {
        }

        @Override
        protected TextureRegion getItemRegion(Track track) {
            return this.isItemEnabled(track) ? TrackSelector.this.mAssets.getTrackRegion(track) : TrackSelector.this.mAssets.getLockedTrackRegion();
        }

        @Override
        public boolean isItemEnabled(Track track) {
            return TrackSelector.this.mRewardManager.isTrackUnlocked(track);
        }
    }
}

