/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class DrawUtils {
    public static void drawCross(ShapeRenderer renderer, Vector2 pos, float radius) {
        DrawUtils.drawCross(renderer, pos.x, pos.y, radius);
    }

    public static void drawCross(ShapeRenderer renderer, float x, float y, float radius) {
        renderer.line(x - radius, y, x + radius, y);
        renderer.line(x, y - radius, x, y + radius);
    }

    public static float setBatchAlpha(Batch batch, float alpha) {
        Color color = batch.getColor();
        float old = color.a;
        color.a = alpha;
        batch.setColor(color);
        return old;
    }

    public static float multiplyBatchAlphaBy(Batch batch, float amount) {
        return DrawUtils.setBatchAlpha(batch, batch.getColor().a * amount);
    }

    public static void drawCentered(Batch batch, TextureRegion region, Vector2 center, float scale, float angle) {
        DrawUtils.drawCentered(batch, region, center.x, center.y, scale, angle);
    }

    public static void drawCentered(Batch batch, TextureRegion region, float x, float y, float scale, float angle) {
        float width = region.getRegionWidth();
        float height = region.getRegionHeight();
        batch.draw(region, x - width / 2.0f, y - height / 2.0f, width / 2.0f, height / 2.0f, width, height, scale, scale, angle);
    }

    public static float getTextureRegionRadius(TextureRegion region) {
        return Vector2.len((float)region.getRegionWidth() / 2.0f, (float)region.getRegionHeight() / 2.0f);
    }

    public static void drawPixelAligned(Batch batch, Drawable drawable, float x, float y, float width, float height, int padding) {
        drawable.draw(batch, MathUtils.floor(x - (float)padding), MathUtils.floor(y - (float)padding), MathUtils.ceil(width + (float)(2 * padding)), MathUtils.ceil(height + (float)(2 * padding)));
    }
}

