/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.ui.InputMapper;
import com.agateau.ui.VirtualKey;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerAdapter;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.utils.IntMap;
import java.util.HashMap;

public class GamepadInputMapper
extends ControllerAdapter
implements InputMapper {
    private Controller mController;
    private final HashMap<VirtualKey, KeyState> mPressedKeys = new HashMap();
    private final HashMap<VirtualKey, Integer> mButtonCodes = new HashMap();
    private final IntMap<VirtualKey> mVirtualKeyForButton = new IntMap();
    private Listener mListener;

    GamepadInputMapper(Controller controller) {
        this.mButtonCodes.put(VirtualKey.TRIGGER, 1);
        this.mButtonCodes.put(VirtualKey.BACK, 2);
        this.mButtonCodes.put(VirtualKey.PAUSE, 3);
        this.setController(controller);
    }

    public Controller getController() {
        return this.mController;
    }

    void setController(Controller controller) {
        this.mController = controller;
        if (controller != null) {
            this.mController.addListener(this);
            this.updateVirtualKeyForButton();
        }
    }

    public int getButtonCodeForVirtualKey(VirtualKey key) {
        return this.mButtonCodes.get((Object)key);
    }

    public void setButtonCodeForVirtualKey(VirtualKey key, int code) {
        this.mButtonCodes.put(key, code);
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    @Override
    public boolean isKeyPressed(VirtualKey key) {
        KeyState state = this.mPressedKeys.get((Object)key);
        return state != null && state != KeyState.RELEASED;
    }

    @Override
    public boolean isKeyJustPressed(VirtualKey key) {
        KeyState state = this.mPressedKeys.get((Object)key);
        if (state == KeyState.JUST_PRESSED) {
            this.mPressedKeys.put(key, KeyState.PRESSED);
            return true;
        }
        return false;
    }

    private void loadButtonFromPreferences(Preferences preferences, String prefix, VirtualKey virtualKey, int defaultValue) {
        String preferenceKey = prefix + virtualKey.toString().toLowerCase();
        int button = preferences.getInteger(preferenceKey, defaultValue);
        this.mButtonCodes.put(virtualKey, button);
    }

    private void saveButtonToPreferences(Preferences preferences, String prefix, VirtualKey virtualKey) {
        String preferenceKey = prefix + virtualKey.toString().toLowerCase();
        preferences.putInteger(preferenceKey, this.mButtonCodes.get((Object)virtualKey));
    }

    @Override
    public void loadConfig(Preferences preferences, String prefix, int playerIdx) {
        this.loadButtonFromPreferences(preferences, prefix, VirtualKey.TRIGGER, 1);
        this.loadButtonFromPreferences(preferences, prefix, VirtualKey.BACK, 2);
        this.loadButtonFromPreferences(preferences, prefix, VirtualKey.PAUSE, 3);
    }

    @Override
    public void saveConfig(Preferences preferences, String prefix) {
        this.saveButtonToPreferences(preferences, prefix, VirtualKey.TRIGGER);
        this.saveButtonToPreferences(preferences, prefix, VirtualKey.BACK);
        this.saveButtonToPreferences(preferences, prefix, VirtualKey.PAUSE);
    }

    @Override
    public boolean isAvailable() {
        return this.mController != null;
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        this.onButtonPressed(buttonCode, true);
        return false;
    }

    @Override
    public boolean buttonUp(Controller controller, int buttonCode) {
        this.onButtonPressed(buttonCode, false);
        return false;
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float fvalue) {
        AxisValue value = GamepadInputMapper.normalizeAxisValue(fvalue);
        if ((axisCode & 1) == 0) {
            this.setKeyJustPressed(VirtualKey.LEFT, value == AxisValue.LESS);
            this.setKeyJustPressed(VirtualKey.RIGHT, value == AxisValue.MORE);
        } else {
            this.setKeyJustPressed(VirtualKey.UP, value == AxisValue.LESS);
            this.setKeyJustPressed(VirtualKey.DOWN, value == AxisValue.MORE);
        }
        return false;
    }

    private void setKeyJustPressed(VirtualKey key, boolean justPressed) {
        this.mPressedKeys.put(key, justPressed ? KeyState.JUST_PRESSED : KeyState.RELEASED);
    }

    private static AxisValue normalizeAxisValue(float value) {
        if (value < -0.5f) {
            return AxisValue.LESS;
        }
        if (value > 0.5f) {
            return AxisValue.MORE;
        }
        return AxisValue.ZERO;
    }

    private void onButtonPressed(int buttonCode, boolean pressed) {
        if (this.mListener != null && this.mListener.onButtonPressed(buttonCode, pressed)) {
            return;
        }
        if (buttonCode == this.mButtonCodes.get((Object)VirtualKey.TRIGGER)) {
            this.setKeyJustPressed(VirtualKey.TRIGGER, pressed);
        } else if (buttonCode == this.mButtonCodes.get((Object)VirtualKey.BACK)) {
            this.setKeyJustPressed(VirtualKey.BACK, pressed);
        } else if (buttonCode == this.mButtonCodes.get((Object)VirtualKey.PAUSE)) {
            this.setKeyJustPressed(VirtualKey.PAUSE, pressed);
        } else {
            VirtualKey key = this.mVirtualKeyForButton.get(buttonCode);
            if (key != null) {
                this.setKeyJustPressed(key, pressed);
            }
        }
    }

    private void updateVirtualKeyForButton() {
        this.mVirtualKeyForButton.clear();
        ControllerMapping mapping = this.mController.getMapping();
        this.mVirtualKeyForButton.put(mapping.buttonDpadDown, VirtualKey.DOWN);
        this.mVirtualKeyForButton.put(mapping.buttonDpadUp, VirtualKey.UP);
        this.mVirtualKeyForButton.put(mapping.buttonDpadLeft, VirtualKey.LEFT);
        this.mVirtualKeyForButton.put(mapping.buttonDpadRight, VirtualKey.RIGHT);
        this.mVirtualKeyForButton.put(mapping.buttonA, VirtualKey.TRIGGER);
        this.mVirtualKeyForButton.put(mapping.buttonB, VirtualKey.BACK);
        this.mVirtualKeyForButton.put(mapping.buttonBack, VirtualKey.BACK);
        this.mVirtualKeyForButton.put(mapping.buttonStart, VirtualKey.PAUSE);
    }

    public static interface Listener {
        public boolean onButtonPressed(int var1, boolean var2);
    }

    private static enum KeyState {
        RELEASED,
        PRESSED,
        JUST_PRESSED;

    }

    private static enum AxisValue {
        LESS,
        ZERO,
        MORE;

    }
}

