/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.animscript;

import com.agateau.ui.DimensionParser;
import com.agateau.ui.animscript.AlignmentArgumentDefinition;
import com.agateau.ui.animscript.AnimScript;
import com.agateau.ui.animscript.ArgumentDefinition;
import com.agateau.ui.animscript.BasicInstructionDefinition;
import com.agateau.ui.animscript.FloatArgumentDefinition;
import com.agateau.ui.animscript.Instruction;
import com.agateau.ui.animscript.InstructionDefinition;
import com.agateau.ui.animscript.InterpolationArgumentDefinition;
import com.agateau.ui.animscript.ParallelInstructionDefinition;
import com.agateau.ui.animscript.RepeatInstructionDefinition;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.utils.Array;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AnimScriptLoader {
    private final Map<String, InstructionDefinition> mInstructionDefinitionMap = new HashMap<String, InstructionDefinition>();

    public AnimScriptLoader() {
        this.registerAction("moveTo", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DIMENSION), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DIMENSION), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION, 0.0f), new InterpolationArgumentDefinition(Interpolation.linear));
        this.registerAction("moveToAligned", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DIMENSION), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DIMENSION), new AlignmentArgumentDefinition(), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION, 0.0f), new InterpolationArgumentDefinition(Interpolation.linear));
        this.registerAction("moveBy", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DIMENSION), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DIMENSION), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION, 0.0f), new InterpolationArgumentDefinition(Interpolation.linear));
        this.registerAction("rotateTo", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.SCALAR), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION, 0.0f), new InterpolationArgumentDefinition(Interpolation.linear));
        this.registerAction("rotateBy", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.SCALAR), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION, 0.0f), new InterpolationArgumentDefinition(Interpolation.linear));
        this.registerAction("scaleTo", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.SCALAR), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.SCALAR), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION, 0.0f), new InterpolationArgumentDefinition(Interpolation.linear));
        this.registerAction("sizeTo", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DIMENSION), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DIMENSION), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION, 0.0f), new InterpolationArgumentDefinition(Interpolation.linear));
        this.registerAction("alpha", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.SCALAR), new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION, 0.0f), new InterpolationArgumentDefinition(Interpolation.linear));
        this.registerAction("show", new ArgumentDefinition[0]);
        this.registerAction("hide", new ArgumentDefinition[0]);
        this.registerAction("delay", new FloatArgumentDefinition(FloatArgumentDefinition.Domain.DURATION));
        this.mInstructionDefinitionMap.put("parallel", new ParallelInstructionDefinition(this));
        this.mInstructionDefinitionMap.put("repeat", new RepeatInstructionDefinition(this));
    }

    public AnimScript load(String definition, DimensionParser dimParser) throws SyntaxException {
        if (definition == null) {
            throw new SyntaxException("definition is null");
        }
        StringReader reader = new StringReader(definition);
        return this.load(reader, dimParser);
    }

    private AnimScript load(Reader reader, DimensionParser dimParser) throws SyntaxException {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.eolIsSignificant(true);
        tokenizer.slashSlashComments(true);
        tokenizer.slashStarComments(true);
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(48, 57);
        tokenizer.commentChar(47);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        Array<Instruction> lst = this.tokenize(tokenizer, null, dimParser);
        return new AnimScript(lst);
    }

    Array<Instruction> tokenize(StreamTokenizer tokenizer, String end, DimensionParser dimParser) throws SyntaxException {
        Array<Instruction> lst = new Array<Instruction>();
        do {
            try {
                while (tokenizer.nextToken() == 10) {
                }
            }
            catch (IOException e) {
                throw new SyntaxException(tokenizer, "Unexpected end of line");
            }
            if (tokenizer.ttype == -1) break;
            if (tokenizer.ttype != -3) {
                throw new SyntaxException(tokenizer, String.format("Unexpected token type %d, (sval='%s')", tokenizer.ttype, tokenizer.sval));
            }
            String cmd = tokenizer.sval;
            assert (cmd != null);
            if (end != null && cmd.equals(end)) break;
            InstructionDefinition def = this.mInstructionDefinitionMap.get(cmd);
            if (def == null) {
                throw new SyntaxException(tokenizer, "Unknown command '" + cmd + "'");
            }
            Instruction instruction = def.parse(tokenizer, dimParser);
            lst.add(instruction);
        } while (tokenizer.ttype != -1);
        return lst;
    }

    private void registerStaticMethod(String name, Class<?> methodClass, String methodName, ArgumentDefinition<?> ... types) {
        Method method = AnimScriptLoader.getMethod(methodClass, methodName, types);
        this.mInstructionDefinitionMap.put(name, new BasicInstructionDefinition(method, types));
    }

    public void registerMemberMethod(String name, Object object, String methodName, ArgumentDefinition<?> ... types) {
        Method method = AnimScriptLoader.getMethod(object.getClass(), methodName, types);
        this.mInstructionDefinitionMap.put(name, new BasicInstructionDefinition(object, method, types));
    }

    private static Method getMethod(Class<?> methodClass, String name, ArgumentDefinition<?> ... types) {
        Class[] args = new Class[types.length];
        for (int idx = 0; idx < types.length; ++idx) {
            args[idx] = types[idx].javaType;
        }
        try {
            return methodClass.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
            throw new RuntimeException();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void registerAction(String name, ArgumentDefinition<?> ... types) {
        this.registerStaticMethod(name, Actions.class, name, types);
    }

    public static class SyntaxException
    extends Exception {
        SyntaxException(String message) {
            super(message);
        }

        SyntaxException(StreamTokenizer tokenizer, String message) {
            super(String.format(Locale.US, "line %d: %s", tokenizer.lineno(), message));
        }
    }
}

