/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.animscript;

import com.agateau.ui.DimensionParser;
import com.agateau.ui.animscript.AnimScriptLoader;
import com.agateau.ui.animscript.ArgumentDefinition;
import com.agateau.ui.animscript.BasicInstruction;
import com.agateau.ui.animscript.Instruction;
import com.agateau.ui.animscript.InstructionDefinition;
import java.io.StreamTokenizer;
import java.lang.reflect.Method;

class BasicInstructionDefinition
implements InstructionDefinition {
    private final Object mInstance;
    private final Method mMethod;
    private final ArgumentDefinition<?>[] mArgumentDefinitions;

    BasicInstructionDefinition(Object instance, Method method, ArgumentDefinition<?> ... argumentDefinitions) {
        this.mInstance = instance;
        this.mMethod = method;
        this.mArgumentDefinitions = argumentDefinitions;
    }

    BasicInstructionDefinition(Method method, ArgumentDefinition<?> ... argumentDefinitions) {
        this.mInstance = null;
        this.mMethod = method;
        this.mArgumentDefinitions = argumentDefinitions;
    }

    @Override
    public Instruction parse(StreamTokenizer tokenizer, DimensionParser dimParser) throws AnimScriptLoader.SyntaxException {
        Object[] args = new Object[this.mArgumentDefinitions.length];
        for (int idx = 0; idx < this.mArgumentDefinitions.length; ++idx) {
            ArgumentDefinition<?> def = this.mArgumentDefinitions[idx];
            assert (def != null);
            args[idx] = def.parse(tokenizer, dimParser);
        }
        return new BasicInstruction(this.mInstance, this.mMethod, args);
    }
}

