/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.ui.InputMapper;
import com.agateau.ui.VirtualKey;
import com.agateau.ui.menu.FocusIndicator;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuInputHandler;
import com.agateau.ui.menu.MenuItem;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.menu.MenuItemTriggerEvent;
import com.agateau.utils.Assert;
import com.agateau.utils.PlatformUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.Array;

public class GridMenuItem<T>
extends Widget
implements MenuItem {
    public static final int INVALID_INDEX = -1;
    private static final float UNFOCUSED_CURRENT_INDICATOR_ALPHA = 0.7f;
    private final Menu mMenu;
    private Array<T> mItems;
    private ItemRenderer<T> mRenderer;
    private int mColumnCount = 3;
    private float mItemWidth = 0.0f;
    private float mItemHeight = 0.0f;
    private TouchUiConfirmMode mTouchUiConfirmMode = TouchUiConfirmMode.DOUBLE_TOUCH;
    private ItemDirection mItemDirection = ItemDirection.LeftToRight;
    private boolean mFocused = false;
    private final Array<Cursor> mCursors = new Array();

    public GridMenuItem(Menu menu) {
        this.mMenu = menu;
        this.mCursors.add(new Cursor(0));
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == 0 && button != 0) {
                    return false;
                }
                int idx = GridMenuItem.this.getIndexAt(x, y);
                if (idx >= 0) {
                    ((Cursor)GridMenuItem.this.mCursors.first()).setCurrentIndex(idx);
                    GridMenuItem.this.trigger();
                }
                return true;
            }
        });
    }

    public void addCursor() {
        this.mCursors.add(new Cursor(this.mCursors.size));
    }

    public void setListener(MenuItemListener listener) {
        this.setListener(0, listener);
    }

    public void setListener(int idx, MenuItemListener listener) {
        this.mCursors.get((int)idx).mMenuItemListener = listener;
    }

    public void setInputMapper(int idx, InputMapper inputMapper) {
        this.mCursors.get(idx).setInputMapper(inputMapper);
    }

    public void setMenuStyle(Menu.MenuStyle menuStyle) {
        this.setMenuStyle(0, menuStyle);
    }

    public void setMenuStyle(int idx, Menu.MenuStyle menuStyle) {
        this.mCursors.get(idx).setMenuStyle(menuStyle);
    }

    public TouchUiConfirmMode getTouchUiConfirmMode() {
        return this.mTouchUiConfirmMode;
    }

    public void setTouchUiConfirmMode(TouchUiConfirmMode touchUiConfirmMode) {
        this.mTouchUiConfirmMode = touchUiConfirmMode;
    }

    public void setItemDirection(ItemDirection itemDirection) {
        this.mItemDirection = itemDirection;
    }

    public void setSelectionListener(SelectionListener<T> selectionListener) {
        this.setSelectionListener(0, selectionListener);
    }

    public void setSelectionListener(int idx, SelectionListener<T> selectionListener) {
        this.mCursors.get((int)idx).mSelectionListener = selectionListener;
    }

    private void setCurrentAndSelect(int cursorIdx, T item, boolean select) {
        Cursor cursor = this.mCursors.get(cursorIdx);
        if (item == null) {
            cursor.setCurrentIndex(0);
            if (select) {
                cursor.setSelectedIndex(-1);
            }
            return;
        }
        int index = this.mItems.indexOf(item, true);
        if (index < 0) {
            NLog.e("Item is not in the item list", new Object[0]);
            return;
        }
        cursor.setCurrentIndex(index);
        if (select) {
            cursor.setSelectedIndex(index);
        }
    }

    public void setCurrent(int cursorIdx, T item) {
        this.setCurrentAndSelect(cursorIdx, item, false);
    }

    public void setCurrent(T item) {
        this.setCurrent(0, item);
    }

    public void setSelected(int cursorIdx, T item) {
        this.setCurrentAndSelect(cursorIdx, item, true);
    }

    public void setSelected(T item) {
        this.setSelected(0, item);
    }

    public boolean isCurrentItemEnabled() {
        T item = this.getCurrent();
        if (item == null) {
            return false;
        }
        return this.mRenderer.isItemEnabled(item);
    }

    public T getSelected(int idx) {
        Cursor cursor = this.mCursors.get(idx);
        return cursor.mSelectedIndex >= 0 ? (T)this.mItems.get(cursor.mSelectedIndex) : null;
    }

    public T getSelected() {
        return this.getSelected(0);
    }

    public T getCurrent() {
        Cursor cursor = this.mCursors.first();
        return cursor.mCurrentIndex >= 0 ? (T)this.mItems.get(cursor.mCurrentIndex) : null;
    }

    public void setItems(Array<T> items) {
        this.mItems = items;
        for (Cursor cursor : this.mCursors) {
            cursor.createFocusIndicators();
            int currentIndex = items.size > 0 ? 0 : -1;
            cursor.setCurrentIndex(currentIndex);
        }
        this.updateHeight();
    }

    public Array<T> getItems() {
        return this.mItems;
    }

    public void setItemRenderer(ItemRenderer<T> renderer) {
        this.mRenderer = renderer;
    }

    public void setItemSize(float width, float height) {
        this.mItemWidth = width;
        this.mItemHeight = height;
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public void setColumnCount(int columnCount) {
        this.mColumnCount = columnCount;
        this.updateHeight();
    }

    private void updateHeight() {
        float height = this.getPrefHeight();
        if (MathUtils.isEqual(height, this.getHeight(), 1.0f)) {
            return;
        }
        this.setHeight(height);
        this.invalidateHierarchy();
    }

    @Override
    public float getPrefWidth() {
        return this.mItemWidth * (float)this.mColumnCount;
    }

    @Override
    public float getPrefHeight() {
        if (this.mItems == null || this.mColumnCount == 0) {
            return 0.0f;
        }
        int rowCount = MathUtils.ceil((float)this.mItems.size / (float)this.mColumnCount);
        return this.mItemHeight * (float)rowCount;
    }

    @Override
    protected void sizeChanged() {
        this.updateHeight();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        for (Cursor cursor : this.mCursors) {
            cursor.act(delta);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.mRenderer == null) {
            NLog.e("No renderer", new Object[0]);
            return;
        }
        if (this.mItemWidth <= 0.0f || this.mItemHeight <= 0.0f) {
            NLog.e("Invalid item size", new Object[0]);
            return;
        }
        DrawUtils.multiplyBatchAlphaBy(batch, parentAlpha);
        float itemSpacing = this.getItemSpacing();
        float x = 0.0f;
        float y = this.getHeight() - this.mItemHeight;
        for (int idx = 0; idx < this.mItems.size; ++idx) {
            T item = this.mItems.get(idx);
            Rectangle rect = this.mRenderer.getItemRectangle(this.mItemWidth, this.mItemHeight, item);
            for (Cursor cursor : this.mCursors) {
                FocusIndicator focusIndicator;
                if (this.mFocused) {
                    focusIndicator = cursor.mFocusIndicators.get(idx);
                    focusIndicator.draw(batch, this.getX() + x + rect.x, this.getY() + y + rect.y, rect.width, rect.height);
                } else if (idx == cursor.mCurrentIndex) {
                    focusIndicator = cursor.mFocusIndicators.get(idx);
                    focusIndicator.drawIndicator(batch, this.getX() + x + rect.x, this.getY() + y + rect.y, rect.width, rect.height, 0.7f);
                }
                if (idx != cursor.mSelectedIndex) continue;
                Menu.MenuStyle style = cursor.mMenuStyle;
                float oldAlpha = DrawUtils.multiplyBatchAlphaBy(batch, 0.5f);
                DrawUtils.drawPixelAligned(batch, style.selected, this.getX() + x + rect.x, this.getY() + y + rect.y, rect.width, rect.height, style.focusPadding);
                DrawUtils.setBatchAlpha(batch, oldAlpha);
            }
            this.mRenderer.render(batch, this.getX() + x, this.getY() + y, this.mItemWidth, this.mItemHeight, item);
            if (this.mItemDirection == ItemDirection.LeftToRight) {
                if ((idx + 1) % this.mColumnCount == 0) {
                    x = 0.0f;
                    y -= this.mItemHeight;
                    continue;
                }
                x += this.mItemWidth + itemSpacing;
                continue;
            }
            if (y - this.mItemHeight < 0.0f) {
                x += this.mItemWidth + itemSpacing;
                y = this.getHeight() - this.mItemHeight;
                continue;
            }
            y -= this.mItemHeight;
        }
    }

    @Override
    public Actor getActor() {
        return this;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void trigger() {
        Cursor cursor = this.mCursors.first();
        cursor.trigger();
    }

    @Override
    public boolean goUp() {
        Cursor cursor = this.mCursors.first();
        return cursor.goUp();
    }

    @Override
    public boolean goDown() {
        Cursor cursor = this.mCursors.first();
        return cursor.goDown();
    }

    @Override
    public void goLeft() {
        Cursor cursor = this.mCursors.first();
        cursor.goLeft();
    }

    @Override
    public void goRight() {
        Cursor cursor = this.mCursors.first();
        cursor.goRight();
    }

    @Override
    public Rectangle getFocusRectangle() {
        Cursor cursor = this.mCursors.first();
        if (cursor.mCurrentIndex == -1) {
            cursor.mFocusRectangle.set(0.0f, 0.0f, -1.0f, -1.0f);
            return cursor.mFocusRectangle;
        }
        T item = this.mItems.get(cursor.mCurrentIndex);
        float x = (float)(cursor.mCurrentIndex % this.mColumnCount) * (this.mItemWidth + this.getItemSpacing());
        float y = this.getHeight() - (float)(cursor.mCurrentIndex / this.mColumnCount + 1) * this.mItemHeight;
        Rectangle rect = this.mRenderer.getItemRectangle(this.mItemWidth, this.mItemHeight, item);
        cursor.mFocusRectangle.set(x + rect.x, y + rect.y, rect.width, rect.height);
        return cursor.mFocusRectangle;
    }

    @Override
    public float getParentWidthRatio() {
        return 1.0f;
    }

    @Override
    public void setFocused(boolean focused) {
        this.mFocused = focused;
        Cursor cursor = this.mCursors.first();
        if (cursor.mCurrentIndex == -1) {
            return;
        }
        cursor.mFocusIndicators.get(cursor.mCurrentIndex).setFocused(focused);
    }

    private float getItemSpacing() {
        return this.mColumnCount > 1 ? (this.getWidth() - this.mItemWidth * (float)this.mColumnCount) / (float)(this.mColumnCount - 1) : 0.0f;
    }

    private int getIndexAt(float touchX, float touchY) {
        if (this.mItems.size == 0) {
            return -1;
        }
        if (this.mItemWidth <= 0.0f || this.mItemHeight <= 0.0f) {
            NLog.e("Invalid item size", new Object[0]);
            return -1;
        }
        float gridWidth = this.mItemWidth + this.getItemSpacing();
        int row = MathUtils.floor((this.getHeight() - touchY) / this.mItemHeight);
        int column = MathUtils.floor(touchX / gridWidth);
        float itemX = (float)column * gridWidth;
        if (itemX + this.mItemWidth < touchX) {
            return -1;
        }
        int idx = this.mItemDirection == ItemDirection.LeftToRight ? row * this.mColumnCount + column : row + column * this.getRowCount();
        if (idx >= 0 && idx < this.mItems.size) {
            return idx;
        }
        return -1;
    }

    private int getRowCount() {
        return (int)(this.getHeight() / this.mItemHeight);
    }

    public static enum TouchUiConfirmMode {
        SINGLE_TOUCH,
        DOUBLE_TOUCH;

    }

    public static interface ItemRenderer<T> {
        public Rectangle getItemRectangle(float var1, float var2, T var3);

        public void render(Batch var1, float var2, float var3, float var4, float var5, T var6);

        public boolean isItemEnabled(T var1);
    }

    public static enum ItemDirection {
        LeftToRight,
        TopToBottom;

    }

    private class Cursor {
        private static final int CURSOR_EXTRA_PADDING = 4;
        public final Rectangle mFocusRectangle = new Rectangle();
        public final Array<FocusIndicator> mFocusIndicators = new Array();
        private final int mRank;
        private Menu.MenuStyle mMenuStyle;
        public int mSelectedIndex = -1;
        public int mCurrentIndex = 0;
        public SelectionListener<T> mSelectionListener;
        public MenuItemListener mMenuItemListener;
        private MenuInputHandler mInputHandler;

        public Cursor(int rank) {
            this.mMenuStyle = GridMenuItem.this.mMenu.getMenuStyle();
            this.mRank = rank;
        }

        public void setInputMapper(InputMapper inputMapper) {
            if (inputMapper == null) {
                this.mInputHandler = null;
            } else {
                this.mInputHandler = new MenuInputHandler();
                this.mInputHandler.setInputMapper(inputMapper);
            }
        }

        public void setMenuStyle(Menu.MenuStyle menuStyle) {
            this.mMenuStyle = menuStyle;
            this.mFocusIndicators.clear();
            this.createFocusIndicators();
        }

        private void createFocusIndicators() {
            if (GridMenuItem.this.mItems == null) {
                return;
            }
            while (this.mFocusIndicators.size < ((GridMenuItem)GridMenuItem.this).mItems.size) {
                FocusIndicator indicator = new FocusIndicator(this.mMenuStyle, this.mRank * 4);
                this.mFocusIndicators.add(indicator);
            }
        }

        public void act(float delta) {
            for (FocusIndicator focusIndicator : this.mFocusIndicators) {
                focusIndicator.act(delta);
            }
            if (this.mInputHandler == null) {
                return;
            }
            this.mInputHandler.act(delta);
            if (this.mInputHandler.isPressed(VirtualKey.LEFT)) {
                this.goLeft();
            }
            if (this.mInputHandler.isPressed(VirtualKey.RIGHT)) {
                this.goRight();
            }
            if (this.mInputHandler.isPressed(VirtualKey.UP)) {
                this.goUp();
            }
            if (this.mInputHandler.isPressed(VirtualKey.DOWN)) {
                this.goDown();
            }
            if (this.mInputHandler.isPressed(VirtualKey.TRIGGER)) {
                this.trigger();
            }
        }

        public void goLeft() {
            if (GridMenuItem.this.mItemDirection == ItemDirection.LeftToRight) {
                if (this.mCurrentIndex > 0) {
                    this.setCurrentIndex(this.mCurrentIndex - 1);
                }
            } else {
                int rowCount = GridMenuItem.this.getRowCount();
                if (this.mCurrentIndex - rowCount >= 0) {
                    this.setCurrentIndex(this.mCurrentIndex - rowCount);
                }
            }
        }

        public void goRight() {
            if (GridMenuItem.this.mItemDirection == ItemDirection.LeftToRight) {
                if (this.mCurrentIndex < ((GridMenuItem)GridMenuItem.this).mItems.size - 1) {
                    this.setCurrentIndex(this.mCurrentIndex + 1);
                }
            } else {
                int rowCount = GridMenuItem.this.getRowCount();
                if (this.mCurrentIndex + rowCount < ((GridMenuItem)GridMenuItem.this).mItems.size) {
                    this.setCurrentIndex(this.mCurrentIndex + rowCount);
                }
            }
        }

        public boolean goUp() {
            if (GridMenuItem.this.mItemDirection == ItemDirection.LeftToRight) {
                if (this.mCurrentIndex - GridMenuItem.this.mColumnCount >= 0) {
                    this.setCurrentIndex(this.mCurrentIndex - GridMenuItem.this.mColumnCount);
                    return true;
                }
                return false;
            }
            if (this.mCurrentIndex > 0) {
                this.setCurrentIndex(this.mCurrentIndex - 1);
                return true;
            }
            return false;
        }

        public boolean goDown() {
            if (GridMenuItem.this.mItemDirection == ItemDirection.LeftToRight) {
                if (this.mCurrentIndex + GridMenuItem.this.mColumnCount < ((GridMenuItem)GridMenuItem.this).mItems.size) {
                    this.setCurrentIndex(this.mCurrentIndex + GridMenuItem.this.mColumnCount);
                    return true;
                }
                return false;
            }
            if (this.mCurrentIndex < ((GridMenuItem)GridMenuItem.this).mItems.size - 1) {
                this.setCurrentIndex(this.mCurrentIndex + 1);
                return true;
            }
            return false;
        }

        public void setCurrentIndex(int currentIndex) {
            if (this.mCurrentIndex == currentIndex) {
                return;
            }
            if (this.mCurrentIndex != -1) {
                this.mFocusIndicators.get(this.mCurrentIndex).setFocused(false);
            }
            this.mCurrentIndex = currentIndex;
            if (this.mCurrentIndex != -1) {
                this.mFocusIndicators.get(this.mCurrentIndex).setFocused(true);
            }
            if (this.mSelectionListener != null) {
                Object item = currentIndex >= 0 ? (Object)GridMenuItem.this.mItems.get(currentIndex) : null;
                this.mSelectionListener.currentChanged(item, currentIndex);
            }
        }

        public void trigger() {
            this.setSelectedIndex(this.mCurrentIndex);
            if (this.mMenuItemListener == null) {
                MenuItemTriggerEvent.fire(GridMenuItem.this);
            } else {
                this.mMenuItemListener.triggered();
            }
        }

        public void setSelectedIndex(int index) {
            if (index < 0) {
                this.mSelectedIndex = -1;
                return;
            }
            Assert.check(index < ((GridMenuItem)GridMenuItem.this).mItems.size, "Invalid index value", new Object[0]);
            Object item = GridMenuItem.this.mItems.get(index);
            if (!GridMenuItem.this.mRenderer.isItemEnabled(item)) {
                this.mSelectedIndex = -1;
                return;
            }
            int oldIndex = this.mSelectedIndex;
            this.mSelectedIndex = index;
            if (this.mSelectionListener != null) {
                if (PlatformUtils.isTouchUi()) {
                    if (GridMenuItem.this.mTouchUiConfirmMode == TouchUiConfirmMode.SINGLE_TOUCH || oldIndex == this.mSelectedIndex) {
                        this.mSelectionListener.selectionConfirmed();
                    }
                } else {
                    this.mSelectionListener.selectionConfirmed();
                }
            }
            this.setCurrentIndex(index);
        }
    }

    public static interface SelectionListener<T> {
        public void currentChanged(T var1, int var2);

        public void selectionConfirmed();
    }
}

