/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels;

import com.agateau.pixelwheels.bonus.BonusPool;
import com.agateau.pixelwheels.gameobject.GameObject;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racescreen.CountDown;
import com.agateau.pixelwheels.stats.GameStats;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;

public interface GameWorld {
    public static final float BOX2D_TIME_STEP = 0.016666668f;
    public static final int VELOCITY_ITERATIONS = 6;
    public static final int POSITION_ITERATIONS = 2;

    public Track getTrack();

    public World getBox2DWorld();

    public Racer getPlayerRacer(int var1);

    public Array<Racer> getPlayerRacers();

    public Array<Racer> getRacers();

    public Array<BonusPool> getBonusPools();

    public Array<GameObject> getActiveGameObjects();

    public void addGameObject(GameObject var1);

    public CountDown getCountDown();

    public int getRacerRank(Racer var1);

    public float getRacerNormalizedRank(Racer var1);

    public GameStats getGameStats();

    public void act(float var1);

    public State getState();

    public void startRace();

    public void setState(State var1);

    public static enum State {
        COUNTDOWN,
        RUNNING,
        FINISHED;

    }
}

