/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gamesetup;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.utils.Array;

public abstract class GameInfo {
    private final Array<Entrant> mEntrants = new Array();
    private final GameType mGameType;

    protected GameInfo(GameType gameType) {
        this.mGameType = gameType;
    }

    public GameType getGameType() {
        return this.mGameType;
    }

    public abstract Track getTrack();

    public Array<Entrant> getEntrants() {
        return this.mEntrants;
    }

    public void sortEntrants() {
        this.mEntrants.sort((e1, e2) -> {
            int cmp = -Integer.compare(e1.getPoints(), e2.getPoints());
            if (cmp != 0) {
                return cmp;
            }
            return Float.compare(e1.getRaceTime(), e2.getRaceTime());
        });
    }

    public int getBestRank() {
        for (int idx = 0; idx < this.mEntrants.size; ++idx) {
            Entrant entrant = this.mEntrants.get(idx);
            if (!entrant.isPlayer()) continue;
            return idx;
        }
        NLog.e("No player entrants found!", new Object[0]);
        return Integer.MAX_VALUE;
    }

    public static enum GameType {
        QUICK_RACE,
        CHAMPIONSHIP;

    }

    public static class Entrant {
        protected String mVehicleId;
        private int mPoints = 0;
        private int mLastRacePoints = 0;
        private float mRaceTime = 0.0f;

        public String getVehicleId() {
            return this.mVehicleId;
        }

        public int getPoints() {
            return this.mPoints;
        }

        public float getRaceTime() {
            return this.mRaceTime;
        }

        public int getLastRacePoints() {
            return this.mLastRacePoints;
        }

        public void addPoints(int points) {
            this.mLastRacePoints = points;
            this.mPoints += points;
        }

        public void addRaceTime(float time) {
            this.mRaceTime += time;
        }

        public boolean isPlayer() {
            return false;
        }
    }

    public static class Player
    extends Entrant {
        private final int mIndex;

        public Player(int idx, String vehicleId) {
            this.mIndex = idx;
            this.mVehicleId = vehicleId;
        }

        public int getIndex() {
            return this.mIndex;
        }

        @Override
        public boolean isPlayer() {
            return true;
        }
    }

    public static abstract class Builder<T extends GameInfo> {
        final Array<VehicleDef> mVehicleDefs;
        final GameConfig mGameConfig;
        Array<Player> mPlayers;

        Builder(Array<VehicleDef> vehicleDefs, GameConfig gameConfig) {
            this.mVehicleDefs = vehicleDefs;
            this.mGameConfig = gameConfig;
        }

        public void setPlayers(Array<Player> players) {
            this.mPlayers = players;
            this.storePlayersInConfig();
        }

        public abstract T build();

        void createEntrants(GameInfo gameInfo) {
            Array<String> vehicleIds = new Array<String>();
            for (VehicleDef vehicleDef : this.mVehicleDefs) {
                vehicleIds.add(vehicleDef.id);
            }
            for (Player player : this.mPlayers) {
                vehicleIds.removeValue(player.mVehicleId, false);
            }
            vehicleIds.shuffle();
            int aiCount = GamePlay.instance.racerCount - this.mPlayers.size;
            gameInfo.mEntrants.clear();
            for (int idx = 0; idx < aiCount; ++idx) {
                Entrant entrant = new Entrant();
                entrant.mVehicleId = (String)vehicleIds.get(idx % vehicleIds.size);
                gameInfo.mEntrants.add(entrant);
            }
            gameInfo.mEntrants.addAll(this.mPlayers);
        }

        private void storePlayersInConfig() {
            for (int idx = 0; idx < this.mGameConfig.vehicles.length; ++idx) {
                String vehicleId;
                this.mGameConfig.vehicles[idx] = vehicleId = idx < this.mPlayers.size ? this.mPlayers.get((int)idx).mVehicleId : "";
            }
            this.mGameConfig.flush(GameConfig.ConfigGroup.OTHER);
        }
    }
}

