/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.stats.TrackStats;
import com.agateau.utils.Assert;
import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.XmlReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ChampionshipIO {
    private final HashMap<Difficulty, Integer> mMaxDrivingForceByDifficulty;

    public ChampionshipIO(HashMap<Difficulty, Integer> maxDrivingForceByDifficulty) {
        this.mMaxDrivingForceByDifficulty = maxDrivingForceByDifficulty;
    }

    public Championship load(FileHandle handle) {
        XmlReader.Element root = FileUtils.parseXml(handle);
        if (root == null) {
            NLog.e("Error loading championship from %s", handle.path());
            throw new RuntimeException("Error loading championship from " + handle.path());
        }
        try {
            return this.load(root);
        }
        catch (Exception e) {
            NLog.e("Error loading championship from %s: %s", handle.path(), e);
            e.printStackTrace();
            throw new RuntimeException("Error loading championship from " + handle.path());
        }
    }

    public Championship load(XmlReader.Element root) {
        String id = root.getAttribute("id");
        String name = root.getAttribute("name");
        Championship championship = new Championship(id, name);
        Array<XmlReader.Element> trackElements = root.getChildrenByName("track");
        Assert.check(trackElements.notEmpty(), "No tracks found in championship " + id, new Object[0]);
        for (XmlReader.Element element : trackElements) {
            this.loadTrack(championship, element);
        }
        return championship;
    }

    private void loadTrack(Championship championship, XmlReader.Element trackElement) {
        String id = trackElement.getAttribute("id");
        String name = trackElement.getAttribute("name");
        Track track = championship.addTrack(id, name);
        HashMap<TrackStats.ResultType, ArrayList<Float>> recordsByType = new HashMap<TrackStats.ResultType, ArrayList<Float>>();
        recordsByType.put(TrackStats.ResultType.LAP, this.loadTrackRecords(trackElement, "lapRecords"));
        recordsByType.put(TrackStats.ResultType.TOTAL, this.loadTrackRecords(trackElement, "totalRecords"));
        for (Difficulty difficulty : Difficulty.values()) {
            float scale = this.computeScaleForDifficulty(difficulty);
            for (TrackStats.ResultType resultType : TrackStats.ResultType.values()) {
                Iterator iterator = ((ArrayList)recordsByType.get((Object)resultType)).iterator();
                while (iterator.hasNext()) {
                    float record = ((Float)iterator.next()).floatValue();
                    record = MathUtils.ceil(record * scale);
                    track.getDefaultTrackRecords(difficulty, resultType).add(Float.valueOf(record));
                }
            }
        }
    }

    private float computeScaleForDifficulty(Difficulty difficulty) {
        if (difficulty == Difficulty.HARD) {
            return 1.0f;
        }
        float ref = this.mMaxDrivingForceByDifficulty.get((Object)Difficulty.HARD).intValue();
        float current = this.mMaxDrivingForceByDifficulty.get((Object)difficulty).intValue();
        return ref / current;
    }

    private ArrayList<Float> loadTrackRecords(XmlReader.Element root, String elementName) {
        ArrayList<Float> records = new ArrayList<Float>();
        XmlReader.Element element = root.getChildByName(elementName);
        if (element == null) {
            return records;
        }
        for (XmlReader.Element recordElement : element.getChildrenByName("record")) {
            float value = recordElement.getFloatAttribute("value");
            records.add(Float.valueOf(value));
        }
        return records;
    }
}

