/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.obstacles.tiled;

import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.obstacles.Obstacle;
import com.agateau.pixelwheels.obstacles.tiled.CircleDef;
import com.agateau.pixelwheels.obstacles.tiled.FullObstacleCreator;
import com.agateau.pixelwheels.obstacles.tiled.MultiDef;
import com.agateau.pixelwheels.obstacles.tiled.RectangleDef;
import com.agateau.pixelwheels.obstacles.tiled.TiledObstacleDef;
import com.agateau.pixelwheels.utils.Box2DUtils;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.utils.Array;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;

public class TiledObstacleCreator {
    private final FullObstacleCreator mFullObstacleCreator;
    private final HashMap<TiledMapTile, TiledObstacleDef> mDefsForTile = new HashMap();

    public static void createObstacles(GameWorld world, TiledMap map) {
        Array<TiledMapTileLayer> layers = map.getLayers().getByType(TiledMapTileLayer.class);
        TiledMapTileLayer firstLayer = layers.first();
        TiledObstacleCreator creator = new TiledObstacleCreator(firstLayer.getWidth(), firstLayer.getHeight(), map.getTileSets().getTileSet(0));
        for (TiledMapTileLayer layer : layers) {
            creator.create(world, layer);
        }
        creator.mFullObstacleCreator.create(world, firstLayer.getTileWidth());
    }

    public TiledObstacleCreator(int width, int height, TiledMapTileSet tileSet) {
        this.mFullObstacleCreator = new FullObstacleCreator(width, height);
        JsonParser parser = new JsonParser();
        for (TiledMapTile tile : tileSet) {
            String json = tile.getProperties().get("obstacle", String.class);
            if (json == null) continue;
            JsonObject root = parser.parse(json).getAsJsonObject();
            String type = root.get("type").getAsString();
            if (type.equals("full")) {
                this.mDefsForTile.put(tile, this.mFullObstacleCreator.getObstacleDef());
                continue;
            }
            TiledObstacleDef def = TiledObstacleCreator.loadDefFromJson(root);
            this.mDefsForTile.put(tile, def);
        }
    }

    static TiledObstacleDef loadDefFromJson(JsonObject root) {
        TiledObstacleDef def;
        String type;
        switch (type = root.get("type").getAsString()) {
            case "circle": {
                def = new CircleDef(root);
                break;
            }
            case "rectangle": {
                def = new RectangleDef(root);
                break;
            }
            case "multi": {
                def = new MultiDef(root);
                break;
            }
            default: {
                throw new RuntimeException("Invalid type value: '" + type + "'");
            }
        }
        return def;
    }

    private void create(GameWorld world, TiledMapTileLayer layer) {
        int tHeight = layer.getHeight();
        int tWidth = layer.getWidth();
        int tileWidth = layer.getTileWidth();
        for (int ty = 0; ty < tHeight; ++ty) {
            for (int tx = 0; tx < tWidth; ++tx) {
                TiledObstacleDef def;
                TiledMapTileLayer.Cell cell = layer.getCell(tx, ty);
                if (cell == null || (def = this.mDefsForTile.get(cell.getTile())) == null) continue;
                def.create(world, tx, ty, tileWidth, cell);
            }
        }
    }

    static void setWallCollisionInfo(Body body) {
        Box2DUtils.setCollisionInfo(body, 1, 14);
        Obstacle.setStaticObstacleRestitution(body);
    }
}

