/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen.debug;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.map.LapPosition;
import com.agateau.pixelwheels.map.LapPositionTable;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.map.WaypointStore;
import com.agateau.pixelwheels.racescreen.GameRenderer;
import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.pixelwheels.utils.OrientedPoint;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;

public class DropLocationDebugObject
extends GameObjectAdapter {
    private final Assets mAssets;
    private final GameRenderer mGameRenderer;
    private final Track mTrack;
    private final Vector2 mCoord = new Vector2();
    private final Vector2 mProjectedCoord = new Vector2();
    private boolean mValid = false;
    private boolean mActive = false;
    private boolean mTouched = false;

    public DropLocationDebugObject(Assets assets, GameRenderer gameRenderer, Track track) {
        this.mAssets = assets;
        this.mGameRenderer = gameRenderer;
        this.mTrack = track;
    }

    @Override
    public void act(float delta) {
        if (!this.mActive) {
            return;
        }
        this.mTouched = Gdx.input.isTouched();
        if (this.mTouched) {
            this.mCoord.set(Gdx.input.getX(), Gdx.input.getY());
            this.mGameRenderer.mapFromScreen(this.mCoord);
            float PFU = 20.0f;
            LapPositionTable table = this.mTrack.getLapPositionTable();
            LapPosition lapPosition = table.get((int)(this.mCoord.x * PFU), (int)(this.mCoord.y * PFU));
            if (lapPosition == null) {
                this.mValid = false;
            } else {
                this.mValid = true;
                WaypointStore store = this.mTrack.getWaypointStore();
                OrientedPoint point = store.getValidPosition(this.mCoord, lapPosition.getLapDistance());
                this.mProjectedCoord.set(point.x, point.y);
            }
        }
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        if (!this.mActive || zLevel != ZLevel.FLYING_HIGH) {
            return;
        }
        TextureRegion region = this.mAssets.target;
        if (this.mTouched) {
            DrawUtils.drawCentered(batch, region, this.mCoord, 0.05f, 0.0f);
        }
        if (this.mValid) {
            DrawUtils.drawCentered(batch, region, this.mProjectedCoord, 0.05f, 45.0f);
        }
    }

    @Override
    public float getX() {
        return 0.0f;
    }

    @Override
    public float getY() {
        return 0.0f;
    }

    public Button createDebugButton(Skin skin) {
        final TextButton button = new TextButton("Waypoints", skin, "tiny");
        button.setProgrammaticChangeEvents(false);
        button.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                DropLocationDebugObject.this.mActive = button.isChecked();
            }
        });
        return button;
    }
}

